/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;
import net.esper.event.property.DynamicPropertyDescriptor;
import net.esper.event.property.DynamicPropertyGetterBase;

public class DynamicIndexedPropertyGetter
extends DynamicPropertyGetterBase
implements EventPropertyGetter {
    private final String getterMethodName;
    private final Object[] params;
    private final int index;

    public DynamicIndexedPropertyGetter(String fieldName, int index) {
        this.getterMethodName = DynamicIndexedPropertyGetter.getGetterMethodName(fieldName);
        this.params = new Object[]{index};
        this.index = index;
    }

    protected Method determineMethod(Class clazz) {
        try {
            return clazz.getMethod(this.getterMethodName, Integer.TYPE);
        }
        catch (NoSuchMethodException ex1) {
            Method method;
            try {
                method = clazz.getMethod(this.getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (!method.getReturnType().isArray()) {
                return null;
            }
            return method;
        }
    }

    protected Object call(DynamicPropertyDescriptor descriptor, Object underlying) {
        try {
            if (descriptor.isHasParameters()) {
                return descriptor.getMethod().invoke(underlying, this.params);
            }
            Object array = descriptor.getMethod().invoke(underlying, null);
            if (array == null) {
                return null;
            }
            return Array.get(array, this.index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
    }

    private static String getGetterMethodName(String propertyName) {
        StringWriter writer = new StringWriter();
        writer.write("get");
        writer.write(Character.toUpperCase(propertyName.charAt(0)));
        writer.write(propertyName.substring(1));
        return writer.toString();
    }
}

