/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;
import net.esper.event.property.DynamicPropertyDescriptor;
import net.esper.event.property.DynamicPropertyGetterBase;

public class DynamicSimplePropertyGetter
extends DynamicPropertyGetterBase
implements EventPropertyGetter {
    private final String getterMethodName;
    private final String isMethodName;

    public DynamicSimplePropertyGetter(String fieldName) {
        this.getterMethodName = DynamicSimplePropertyGetter.getGetterMethodName(fieldName);
        this.isMethodName = DynamicSimplePropertyGetter.getIsMethodName(fieldName);
    }

    protected Object call(DynamicPropertyDescriptor descriptor, Object underlying) {
        try {
            return descriptor.getMethod().invoke(underlying, null);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
    }

    protected Method determineMethod(Class clazz) {
        try {
            return clazz.getMethod(this.getterMethodName, new Class[0]);
        }
        catch (NoSuchMethodException ex1) {
            try {
                return clazz.getMethod(this.isMethodName, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
    }

    private static String getGetterMethodName(String propertyName) {
        StringWriter writer = new StringWriter();
        writer.write("get");
        writer.write(Character.toUpperCase(propertyName.charAt(0)));
        writer.write(propertyName.substring(1));
        return writer.toString();
    }

    private static String getIsMethodName(String propertyName) {
        StringWriter writer = new StringWriter();
        writer.write("is");
        writer.write(Character.toUpperCase(propertyName.charAt(0)));
        writer.write(propertyName.substring(1));
        return writer.toString();
    }
}

