/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.esper.event.BeanEventType;
import net.esper.event.EventPropertyDescriptor;
import net.esper.event.EventPropertyGetter;
import net.esper.event.property.ArrayFastPropertyGetter;
import net.esper.event.property.ArrayFieldPropertyGetter;
import net.esper.event.property.ArrayMethodPropertyGetter;
import net.esper.event.property.KeyedFastPropertyGetter;
import net.esper.event.property.KeyedMethodPropertyGetter;
import net.esper.event.property.PropertyBase;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class IndexedProperty
extends PropertyBase {
    private int index;

    public IndexedProperty(String propertyName, int index) {
        super(propertyName);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public EventPropertyGetter getGetter(BeanEventType eventType) {
        FastClass fastClass = eventType.getFastClass();
        EventPropertyDescriptor propertyDesc = eventType.getIndexedProperty(this.propertyName);
        if (propertyDesc != null) {
            if (fastClass != null) {
                Method method = propertyDesc.getReadMethod();
                FastMethod fastMethod = fastClass.getMethod(method);
                return new KeyedFastPropertyGetter(fastMethod, this.index);
            }
            return new KeyedMethodPropertyGetter(propertyDesc.getReadMethod(), this.index);
        }
        propertyDesc = eventType.getSimpleProperty(this.propertyName);
        if (propertyDesc == null) {
            return null;
        }
        Class returnType = propertyDesc.getReturnType();
        if (returnType.isArray()) {
            if (propertyDesc.getReadMethod() != null) {
                Method method = propertyDesc.getReadMethod();
                if (fastClass != null) {
                    FastMethod fastMethod = fastClass.getMethod(method);
                    return new ArrayFastPropertyGetter(fastMethod, this.index);
                }
                return new ArrayMethodPropertyGetter(method, this.index);
            }
            Field field = propertyDesc.getAccessorField();
            return new ArrayFieldPropertyGetter(field, this.index);
        }
        return null;
    }

    public Class getPropertyType(BeanEventType eventType) {
        EventPropertyDescriptor descriptor = eventType.getIndexedProperty(this.propertyName);
        if (descriptor != null) {
            return descriptor.getReturnType();
        }
        descriptor = eventType.getSimpleProperty(this.propertyName);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (returnType.isArray()) {
            return returnType.getComponentType();
        }
        return null;
    }

    public Class getPropertyTypeMap() {
        return null;
    }

    public EventPropertyGetter getGetterMap() {
        return null;
    }
}

