/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.InvocationTargetException;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;
import net.sf.cglib.reflect.FastMethod;

public class KeyedFastPropertyGetter
implements EventPropertyGetter {
    private final FastMethod fastMethod;
    private final Object key;

    public KeyedFastPropertyGetter(FastMethod fastMethod, Object key) {
        this.key = key;
        this.fastMethod = fastMethod;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        try {
            return this.fastMethod.invoke(underlying, new Object[]{this.key});
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
    }

    public String toString() {
        return "KeyedFastPropertyGetter  fastMethod=" + this.fastMethod.toString() + " key=" + this.key;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

