/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;

public class KeyedMethodPropertyGetter
implements EventPropertyGetter {
    private final Method method;
    private final Object key;

    public KeyedMethodPropertyGetter(Method method, Object key) {
        this.key = key;
        this.method = method;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        try {
            return this.method.invoke(underlying, this.key);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
    }

    public String toString() {
        return "KeyedMethodPropertyGetter  method=" + this.method.toString() + " key=" + this.key;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

