/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.Array;
import java.util.Map;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;

public class MapIndexedPropertyGetter
implements EventPropertyGetter {
    private final int index;
    private final String fieldName;

    public MapIndexedPropertyGetter(String fieldName, int index) {
        this.index = index;
        this.fieldName = fieldName;
    }

    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object underlying = eventBean.getUnderlying();
        if (!(underlying instanceof Map)) {
            return null;
        }
        Map map = (Map)underlying;
        Object value = map.get(this.fieldName);
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            return null;
        }
        if (this.index >= Array.getLength(value)) {
            return null;
        }
        return Array.get(value, this.index);
    }

    public boolean isExistsProperty(EventBean eventBean) {
        Object underlying = eventBean.getUnderlying();
        if (!(underlying instanceof Map)) {
            return false;
        }
        Map map = (Map)underlying;
        Object value = map.get(this.fieldName);
        if (value == null) {
            return false;
        }
        if (!value.getClass().isArray()) {
            return false;
        }
        return this.index < Array.getLength(value);
    }
}

