/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.util.List;
import java.util.Map;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.MapEventBean;
import net.esper.event.PropertyAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapNestedPropertyGetter
implements EventPropertyGetter {
    private final EventPropertyGetter[] getterChain;

    public MapNestedPropertyGetter(List<EventPropertyGetter> getterChain) {
        this.getterChain = getterChain.toArray(new EventPropertyGetter[0]);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object value = null;
        for (int i = 0; i < this.getterChain.length; ++i) {
            Object result = this.getterChain[i].get(eventBean);
            if (result == null) {
                return null;
            }
            if (i < this.getterChain.length - 1) {
                if (!(result instanceof Map)) {
                    return null;
                }
                eventBean = new MapEventBean((Map)result, null);
                continue;
            }
            value = result;
        }
        return value;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        int lastElementIndex = this.getterChain.length - 1;
        for (int i = 0; i < this.getterChain.length - 1; ++i) {
            Object result = this.getterChain[i].get(eventBean);
            if (result == null) {
                return false;
            }
            if (!(result instanceof Map)) {
                return false;
            }
            eventBean = new MapEventBean((Map)result, null);
        }
        return this.getterChain[lastElementIndex].isExistsProperty(eventBean);
    }
}

