/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.util.Map;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.MapEventBean;
import net.esper.event.PropertyAccessException;

public class MapPropertyGetter
implements EventPropertyGetter {
    private final String propertyMap;
    private final EventPropertyGetter getter;

    public MapPropertyGetter(String propertyMap, EventPropertyGetter getter) {
        if (getter == null) {
            throw new IllegalArgumentException("Getter is a required parameter");
        }
        this.propertyMap = propertyMap;
        this.getter = getter;
    }

    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object result = eventBean.getUnderlying();
        if (!(result instanceof Map)) {
            return null;
        }
        Map map = (Map)result;
        Object valueTopObj = map.get(this.propertyMap);
        if (!(valueTopObj instanceof Map)) {
            return null;
        }
        Map valueTop = (Map)valueTopObj;
        if (valueTop == null) {
            return null;
        }
        MapEventBean event = new MapEventBean(valueTop, null);
        return this.getter.get(event);
    }

    public boolean isExistsProperty(EventBean eventBean) {
        Object result = eventBean.getUnderlying();
        if (!(result instanceof Map)) {
            return false;
        }
        Map map = (Map)result;
        Object valueTopObj = map.get(this.propertyMap);
        if (!(valueTopObj instanceof Map)) {
            return false;
        }
        Map valueTop = (Map)valueTopObj;
        if (valueTop == null) {
            return false;
        }
        MapEventBean event = new MapEventBean(valueTop, null);
        return this.getter.isExistsProperty(event);
    }
}

