/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.Method;
import net.esper.event.BeanEventType;
import net.esper.event.EventPropertyDescriptor;
import net.esper.event.EventPropertyGetter;
import net.esper.event.property.KeyedFastPropertyGetter;
import net.esper.event.property.KeyedMethodPropertyGetter;
import net.esper.event.property.PropertyBase;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class MappedProperty
extends PropertyBase {
    private String key;

    public MappedProperty(String propertyName, String key) {
        super(propertyName);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public EventPropertyGetter getGetter(BeanEventType eventType) {
        EventPropertyDescriptor propertyDesc = eventType.getMappedProperty(this.propertyName);
        if (propertyDesc == null) {
            return null;
        }
        Method method = propertyDesc.getReadMethod();
        FastClass fastClass = eventType.getFastClass();
        if (fastClass != null) {
            FastMethod fastMethod = fastClass.getMethod(method);
            return new KeyedFastPropertyGetter(fastMethod, this.key);
        }
        return new KeyedMethodPropertyGetter(method, this.key);
    }

    public Class getPropertyType(BeanEventType eventType) {
        EventPropertyDescriptor propertyDesc = eventType.getMappedProperty(this.propertyName);
        if (propertyDesc == null) {
            return null;
        }
        return propertyDesc.getReadMethod().getReturnType();
    }

    public Class getPropertyTypeMap() {
        return null;
    }

    public EventPropertyGetter getGetterMap() {
        return null;
    }
}

