/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.event.BeanEventType;
import net.esper.event.BeanEventTypeFactory;
import net.esper.event.EventPropertyGetter;
import net.esper.event.property.DynamicProperty;
import net.esper.event.property.MapNestedPropertyGetter;
import net.esper.event.property.NestedPropertyGetter;
import net.esper.event.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedProperty
implements Property {
    private List<Property> properties;
    private BeanEventTypeFactory beanEventTypeFactory;

    public NestedProperty(List<Property> properties, BeanEventTypeFactory beanEventTypeFactory) {
        this.properties = properties;
        this.beanEventTypeFactory = beanEventTypeFactory;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public EventPropertyGetter getGetter(BeanEventType eventType) {
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            EventPropertyGetter getter = property.getGetter(eventType);
            if (getter == null) {
                return null;
            }
            if (it.hasNext()) {
                Class clazz = property.getPropertyType(eventType);
                if (clazz == null) {
                    return null;
                }
                if (clazz == Map.class) {
                    return null;
                }
                if (clazz.isArray()) {
                    return null;
                }
                eventType = this.beanEventTypeFactory.createBeanType(clazz.getName(), clazz);
            }
            getters.add(getter);
        }
        return new NestedPropertyGetter(getters, this.beanEventTypeFactory);
    }

    @Override
    public Class getPropertyType(BeanEventType eventType) {
        Class result = null;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            result = property.getPropertyType(eventType);
            if (result == null) {
                return null;
            }
            if (!it.hasNext()) continue;
            if (result == Map.class) {
                return null;
            }
            if (result.isArray()) {
                return null;
            }
            eventType = this.beanEventTypeFactory.createBeanType(result.getName(), result);
        }
        return result;
    }

    @Override
    public Class getPropertyTypeMap() {
        if (this.properties.get(0) instanceof DynamicProperty) {
            return Object.class;
        }
        return null;
    }

    @Override
    public EventPropertyGetter getGetterMap() {
        if (!(this.properties.get(0) instanceof DynamicProperty)) {
            return null;
        }
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        for (Property property : this.properties) {
            EventPropertyGetter getter = property.getGetterMap();
            if (getter == null) {
                return null;
            }
            getters.add(getter);
        }
        return new MapNestedPropertyGetter(getters);
    }
}

