/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.util.List;
import net.esper.event.BeanEventBean;
import net.esper.event.BeanEventType;
import net.esper.event.BeanEventTypeFactory;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedPropertyGetter
implements EventPropertyGetter {
    private final EventPropertyGetter[] getterChain;
    private final BeanEventTypeFactory beanEventTypeFactory;

    public NestedPropertyGetter(List<EventPropertyGetter> getterChain, BeanEventTypeFactory beanEventTypeFactory) {
        this.getterChain = getterChain.toArray(new EventPropertyGetter[0]);
        this.beanEventTypeFactory = beanEventTypeFactory;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object value = null;
        for (int i = 0; i < this.getterChain.length; ++i) {
            value = this.getterChain[i].get(eventBean);
            if (value == null) {
                return null;
            }
            if (i >= this.getterChain.length - 1) continue;
            BeanEventType type = this.beanEventTypeFactory.createBeanType(value.getClass().getName(), value.getClass());
            eventBean = new BeanEventBean(value, type);
        }
        return value;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        int lastElementIndex = this.getterChain.length - 1;
        for (int i = 0; i < this.getterChain.length - 1; ++i) {
            Object value = this.getterChain[i].get(eventBean);
            if (value == null) {
                return false;
            }
            BeanEventType type = this.beanEventTypeFactory.createBeanType(value.getClass().getName(), value.getClass());
            eventBean = new BeanEventBean(value, type);
        }
        return this.getterChain[lastElementIndex].isExistsProperty(eventBean);
    }
}

