/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.esper.event.CGLibPropertyGetter;
import net.esper.event.EventPropertyDescriptor;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventPropertyType;
import net.esper.event.ReflectionPropMethodGetter;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyHelper {
    private static final Log log = LogFactory.getLog(PropertyHelper.class);

    public static EventPropertyGetter getGetter(Method method, FastClass fastClass) {
        FastMethod fastMethod = null;
        try {
            if (fastClass != null) {
                fastMethod = fastClass.getMethod(method);
            }
        }
        catch (Throwable ex) {
            log.warn(".getAccessors Unable to obtain CGLib fast method implementation, msg=" + ex.getMessage());
        }
        EventPropertyGetter getter = fastMethod != null ? new CGLibPropertyGetter(fastMethod) : new ReflectionPropMethodGetter(method);
        return getter;
    }

    public static List<EventPropertyDescriptor> getProperties(Class clazz) {
        HashSet<Class> propertyOrigClasses = new HashSet<Class>();
        PropertyHelper.getImplementedInterfaceParents(clazz, propertyOrigClasses);
        propertyOrigClasses.add(clazz);
        return PropertyHelper.getPropertiesForClasses(propertyOrigClasses);
    }

    private static void getImplementedInterfaceParents(Class clazz, Set<Class> classesResult) {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null) {
            return;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            classesResult.add(interfaces[i]);
            PropertyHelper.getImplementedInterfaceParents(interfaces[i], classesResult);
        }
    }

    private static List<EventPropertyDescriptor> getPropertiesForClasses(Set<Class> propertyClasses) {
        LinkedList<EventPropertyDescriptor> result = new LinkedList<EventPropertyDescriptor>();
        for (Class clazz : propertyClasses) {
            PropertyHelper.addIntrospectProperties(clazz, result);
            PropertyHelper.addMappedProperties(clazz, result);
        }
        PropertyHelper.removeDuplicateProperties(result);
        PropertyHelper.removeJavaProperties(result);
        return result;
    }

    protected static void removeJavaProperties(List<EventPropertyDescriptor> properties) {
        LinkedList<EventPropertyDescriptor> toRemove = new LinkedList<EventPropertyDescriptor>();
        for (EventPropertyDescriptor desc : properties) {
            if (!desc.getPropertyName().equals("class") && !desc.getPropertyName().equals("getClass") && !desc.getPropertyName().equals("toString") && !desc.getPropertyName().equals("hashCode")) continue;
            toRemove.add(desc);
        }
        for (EventPropertyDescriptor desc : toRemove) {
            properties.remove(desc);
        }
    }

    protected static void removeDuplicateProperties(List<EventPropertyDescriptor> properties) {
        LinkedHashMap<String, EventPropertyDescriptor> set = new LinkedHashMap<String, EventPropertyDescriptor>();
        LinkedList<EventPropertyDescriptor> toRemove = new LinkedList<EventPropertyDescriptor>();
        for (EventPropertyDescriptor desc : properties) {
            if (set.containsKey(desc.getPropertyName())) {
                toRemove.add(desc);
                continue;
            }
            set.put(desc.getPropertyName(), desc);
        }
        for (EventPropertyDescriptor desc : toRemove) {
            properties.remove(desc);
        }
    }

    protected static void addIntrospectProperties(Class clazz, List<EventPropertyDescriptor> result) {
        PropertyDescriptor[] properties = PropertyHelper.introspect(clazz);
        for (int i = 0; i < properties.length; ++i) {
            String propertyName;
            PropertyDescriptor property = properties[i];
            String listedName = propertyName = property.getName();
            Method readMethod = property.getReadMethod();
            EventPropertyType type = EventPropertyType.SIMPLE;
            if (property instanceof IndexedPropertyDescriptor) {
                readMethod = ((IndexedPropertyDescriptor)property).getIndexedReadMethod();
                type = EventPropertyType.INDEXED;
                listedName = propertyName + "[]";
            }
            result.add(new EventPropertyDescriptor(propertyName, listedName, readMethod, type));
        }
    }

    protected static void addMappedProperties(Class clazz, List<EventPropertyDescriptor> result) {
        HashSet<String> uniquePropertyNames = new HashSet<String>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            String inferredName;
            String methodName = methods[i].getName();
            if (!methodName.startsWith("get") || (inferredName = methodName.substring(3, methodName.length())).length() == 0 || (parameterTypes = methods[i].getParameterTypes()).length != 1 || parameterTypes[0] != String.class) continue;
            String newInferredName = null;
            if (inferredName.length() >= 2 && Character.isUpperCase(inferredName.charAt(0)) && Character.isUpperCase(inferredName.charAt(1))) {
                newInferredName = inferredName;
            }
            if (newInferredName == null) {
                newInferredName = Character.toString(Character.toLowerCase(inferredName.charAt(0)));
                if (inferredName.length() > 1) {
                    newInferredName = newInferredName + inferredName.substring(1, inferredName.length());
                }
            }
            if (uniquePropertyNames.contains(inferredName = newInferredName)) continue;
            String listedName = inferredName + "()";
            result.add(new EventPropertyDescriptor(inferredName, listedName, methods[i], EventPropertyType.MAPPED));
            uniquePropertyNames.add(inferredName);
        }
    }

    protected static PropertyDescriptor[] introspect(Class clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        return beanInfo.getPropertyDescriptors();
    }
}

