/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.esper.client.ConfigurationEventTypeLegacy;
import net.esper.client.ConfigurationException;
import net.esper.event.EventPropertyDescriptor;
import net.esper.event.EventPropertyType;
import net.esper.event.property.PropertyListBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListBuilderExplicit
implements PropertyListBuilder {
    private ConfigurationEventTypeLegacy legacyConfig;

    public PropertyListBuilderExplicit(ConfigurationEventTypeLegacy legacyConfig) {
        if (legacyConfig == null) {
            throw new IllegalArgumentException("Required configuration not passed");
        }
        this.legacyConfig = legacyConfig;
    }

    @Override
    public List<EventPropertyDescriptor> assessProperties(Class clazz) {
        LinkedList<EventPropertyDescriptor> result = new LinkedList<EventPropertyDescriptor>();
        PropertyListBuilderExplicit.getExplicitProperties(result, clazz, this.legacyConfig);
        return result;
    }

    protected static void getExplicitProperties(List<EventPropertyDescriptor> result, Class clazz, ConfigurationEventTypeLegacy legacyConfig) {
        for (ConfigurationEventTypeLegacy.LegacyFieldPropDesc legacyFieldPropDesc : legacyConfig.getFieldProperties()) {
            result.add(PropertyListBuilderExplicit.makeDesc(clazz, legacyFieldPropDesc));
        }
        for (ConfigurationEventTypeLegacy.LegacyMethodPropDesc legacyMethodPropDesc : legacyConfig.getMethodProperties()) {
            result.add(PropertyListBuilderExplicit.makeDesc(clazz, legacyMethodPropDesc));
        }
    }

    private static EventPropertyDescriptor makeDesc(Class clazz, ConfigurationEventTypeLegacy.LegacyMethodPropDesc methodDesc) {
        Method[] methods = clazz.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodDesc.getAccessorMethodName()) || methods[i].getReturnType() == Void.TYPE || methods[i].getParameterTypes().length >= 2) continue;
            if (methods[i].getParameterTypes().length == 0) {
                method = methods[i];
                break;
            }
            Class<?> parameterType = methods[i].getParameterTypes()[0];
            if (parameterType != Integer.TYPE && parameterType != Integer.class && parameterType != String.class) continue;
            method = methods[i];
            break;
        }
        if (method == null) {
            throw new ConfigurationException("Configured method named '" + methodDesc.getAccessorMethodName() + "' not found for class " + clazz.getName());
        }
        return PropertyListBuilderExplicit.makeMethodDesc(method, methodDesc.getName());
    }

    private static EventPropertyDescriptor makeDesc(Class clazz, ConfigurationEventTypeLegacy.LegacyFieldPropDesc fieldDesc) {
        Field field = null;
        try {
            field = clazz.getField(fieldDesc.getAccessorFieldName());
        }
        catch (NoSuchFieldException ex) {
            throw new ConfigurationException("Configured field named '" + fieldDesc.getAccessorFieldName() + "' not found for class " + clazz.getName());
        }
        return PropertyListBuilderExplicit.makeFieldDesc(field, fieldDesc.getName());
    }

    protected static EventPropertyDescriptor makeFieldDesc(Field field, String name) {
        return new EventPropertyDescriptor(name, name, field, EventPropertyType.SIMPLE);
    }

    protected static EventPropertyDescriptor makeMethodDesc(Method method, String name) {
        Class<?> parameterType;
        EventPropertyType propertyType = null;
        propertyType = method.getParameterTypes().length == 1 ? ((parameterType = method.getParameterTypes()[0]) == String.class ? EventPropertyType.MAPPED : EventPropertyType.INDEXED) : EventPropertyType.SIMPLE;
        return new EventPropertyDescriptor(name, name, method, propertyType);
    }
}

