/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.esper.client.ConfigurationEventTypeLegacy;
import net.esper.event.EventPropertyDescriptor;
import net.esper.event.property.PropertyHelper;
import net.esper.event.property.PropertyListBuilder;
import net.esper.event.property.PropertyListBuilderExplicit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListBuilderPublic
implements PropertyListBuilder {
    private ConfigurationEventTypeLegacy legacyConfig;

    public PropertyListBuilderPublic(ConfigurationEventTypeLegacy legacyConfig) {
        if (legacyConfig == null) {
            throw new IllegalArgumentException("Required configuration not passed");
        }
        this.legacyConfig = legacyConfig;
    }

    @Override
    public List<EventPropertyDescriptor> assessProperties(Class clazz) {
        LinkedList<EventPropertyDescriptor> result = new LinkedList<EventPropertyDescriptor>();
        PropertyListBuilderExplicit.getExplicitProperties(result, clazz, this.legacyConfig);
        PropertyListBuilderPublic.addPublicFields(result, clazz);
        PropertyListBuilderPublic.addPublicMethods(result, clazz);
        return result;
    }

    private static void addPublicMethods(List<EventPropertyDescriptor> result, Class clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> parameterType;
            if (methods[i].getReturnType() == Void.TYPE || methods[i].getParameterTypes().length >= 2 || methods[i].getParameterTypes().length == 1 && (parameterType = methods[i].getParameterTypes()[0]) != Integer.TYPE && parameterType != Integer.class && parameterType != String.class) continue;
            EventPropertyDescriptor desc = PropertyListBuilderExplicit.makeMethodDesc(methods[i], methods[i].getName());
            result.add(desc);
        }
        PropertyHelper.removeJavaProperties(result);
    }

    private static void addPublicFields(List<EventPropertyDescriptor> result, Class clazz) {
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            EventPropertyDescriptor desc = PropertyListBuilderExplicit.makeFieldDesc(fields[i], fields[i].getName());
            result.add(desc);
        }
    }
}

