/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.LinkedList;
import net.esper.eql.generated.EQLStatementLexer;
import net.esper.eql.generated.EQLStatementParser;
import net.esper.eql.generated.EqlTokenTypes;
import net.esper.event.BeanEventTypeFactory;
import net.esper.event.PropertyAccessException;
import net.esper.event.property.DynamicIndexedProperty;
import net.esper.event.property.DynamicMappedProperty;
import net.esper.event.property.DynamicSimpleProperty;
import net.esper.event.property.IndexedProperty;
import net.esper.event.property.MappedProperty;
import net.esper.event.property.NestedProperty;
import net.esper.event.property.Property;
import net.esper.event.property.SimpleProperty;
import net.esper.type.IntValue;
import net.esper.type.StringValue;

public class PropertyParser
implements EqlTokenTypes {
    public static Property parse(String propertyName, BeanEventTypeFactory beanEventTypeFactory) {
        EQLStatementLexer lexer2 = new EQLStatementLexer(new StringReader(propertyName));
        EQLStatementParser parser2 = new EQLStatementParser(lexer2);
        try {
            parser2.startEventPropertyRule();
        }
        catch (TokenStreamException e) {
            throw new PropertyAccessException("Failed to parse property name '" + propertyName + '\'', e);
        }
        catch (RecognitionException e) {
            throw new PropertyAccessException("Failed to parse property name '" + propertyName + '\'', e);
        }
        AST ast = parser2.getAST();
        if (ast.getNumberOfChildren() == 1) {
            return PropertyParser.makeProperty(ast.getFirstChild(), false);
        }
        AST child = ast.getFirstChild();
        LinkedList<Property> properties = new LinkedList<Property>();
        boolean isRootedInDynamic = false;
        do {
            Property property;
            if ((property = PropertyParser.makeProperty(child, isRootedInDynamic)) instanceof DynamicSimpleProperty) {
                isRootedInDynamic = true;
            }
            properties.add(property);
        } while ((child = child.getNextSibling()) != null);
        return new NestedProperty(properties, beanEventTypeFactory);
    }

    private static Property makeProperty(AST child, boolean isRootedInDynamic) {
        switch (child.getType()) {
            case 115: {
                if (!isRootedInDynamic) {
                    return new SimpleProperty(child.getFirstChild().getText());
                }
                return new DynamicSimpleProperty(child.getFirstChild().getText());
            }
            case 116: {
                String key = StringValue.parseString(child.getFirstChild().getNextSibling().getText());
                if (!isRootedInDynamic) {
                    return new MappedProperty(child.getFirstChild().getText(), key);
                }
                return new DynamicMappedProperty(child.getFirstChild().getText(), key);
            }
            case 117: {
                int index = IntValue.parseString(child.getFirstChild().getNextSibling().getText());
                if (!isRootedInDynamic) {
                    return new IndexedProperty(child.getFirstChild().getText(), index);
                }
                return new DynamicIndexedProperty(child.getFirstChild().getText(), index);
            }
            case 118: {
                return new DynamicSimpleProperty(child.getFirstChild().getText());
            }
            case 119: {
                int index = IntValue.parseString(child.getFirstChild().getNextSibling().getText());
                return new DynamicIndexedProperty(child.getFirstChild().getText(), index);
            }
            case 120: {
                String key = StringValue.parseString(child.getFirstChild().getNextSibling().getText());
                return new DynamicMappedProperty(child.getFirstChild().getText(), key);
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }
}

