/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.xml;

import com.sun.org.apache.xerces.internal.impl.dv.xs.XSSimpleTypeDecl;
import com.sun.org.apache.xerces.internal.xs.XSAttributeUse;
import com.sun.org.apache.xerces.internal.xs.XSComplexTypeDefinition;
import com.sun.org.apache.xerces.internal.xs.XSElementDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import com.sun.org.apache.xerces.internal.xs.XSModelGroup;
import com.sun.org.apache.xerces.internal.xs.XSNamedMap;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSParticle;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import net.esper.client.EPException;

public class SchemaUtil {
    public static QName simpleTypeToQName(XSSimpleTypeDecl definition) {
        switch (definition.getPrimitiveKind()) {
            case 2: {
                return XPathConstants.BOOLEAN;
            }
            case 5: {
                return XPathConstants.NUMBER;
            }
            case 1: {
                return XPathConstants.STRING;
            }
            case 3: {
                return XPathConstants.NUMBER;
            }
        }
        throw new EPException("Unexpected schema simple type encountered '" + definition.getPrimitiveKind() + '\'');
    }

    public static XSElementDeclaration findRootElement(XSModel schema, String namespace, String elementName) {
        XSNamedMap elements;
        if (namespace != null && namespace.length() != 0) {
            elements = schema.getComponentsByNamespace((short)2, namespace);
            if (elements == null) {
                throw new EPException("Empty element declaration list returned by schema for namespace '" + namespace + '\'');
            }
        } else {
            elements = schema.getComponents((short)2);
        }
        for (int i = 0; i < elements.getLength(); ++i) {
            XSElementDeclaration decl = (XSElementDeclaration)elements.item(i);
            if (!decl.getName().equals(elementName)) continue;
            return decl;
        }
        String text = "Could not find root element declaration in schema using element name '" + elementName + '\'';
        if (namespace != null) {
            text = text + " in namespace '" + namespace + '\'';
        }
        throw new EPException(text);
    }

    public static XSObject findPropertyMapping(XSComplexTypeDefinition def, String property) {
        XSParticle particle;
        XSObjectList attrs = def.getAttributeUses();
        for (int i = 0; i < attrs.getLength(); ++i) {
            XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
            String name = attr.getAttrDeclaration().getName();
            if (!name.equals(property)) continue;
            return attr;
        }
        if ((def.getContentType() == 2 || def.getContentType() == 3) && (particle = def.getParticle()).getTerm() instanceof XSModelGroup) {
            XSModelGroup group = (XSModelGroup)particle.getTerm();
            XSObjectList particles = group.getParticles();
            for (int i = 0; i < particles.getLength(); ++i) {
                XSParticle childParticle = (XSParticle)particles.item(i);
                if (!childParticle.getTerm().getName().equals(property)) continue;
                return childParticle;
            }
        }
        return null;
    }
}

