/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.xml;

import com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl;
import com.sun.org.apache.xerces.internal.xs.XSImplementation;
import com.sun.org.apache.xerces.internal.xs.XSLoader;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import net.esper.client.ConfigurationEventTypeXMLDOM;
import net.esper.client.EPException;
import net.esper.event.EventPropertyGetter;
import net.esper.event.TypedEventPropertyGetter;
import net.esper.event.xml.BaseXMLEventType;
import net.esper.event.xml.SchemaXMLPropertyParser;
import net.esper.event.xml.XPathNamespaceContext;
import net.esper.util.ResourceLoader;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class SchemaXMLEventType
extends BaseXMLEventType {
    private XSModel xsModel;
    private String rootElementNamespace;
    private Map<String, TypedEventPropertyGetter> propertyGetterCache = new HashMap<String, TypedEventPropertyGetter>();

    public SchemaXMLEventType(ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM) {
        super(configurationEventTypeXMLDOM);
        String schemaResource = configurationEventTypeXMLDOM.getSchemaResource();
        try {
            this.readSchema(schemaResource);
        }
        catch (EPException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EPException("Failed to read schema '" + schemaResource + '\'', ex);
        }
        this.rootElementNamespace = configurationEventTypeXMLDOM.getRootElementNamespace();
        XPathNamespaceContext ctx = new XPathNamespaceContext();
        if (configurationEventTypeXMLDOM.getDefaultNamespace() != null) {
            ctx.setDefaultNamespace(configurationEventTypeXMLDOM.getDefaultNamespace());
        }
        for (Map.Entry<String, String> entry : configurationEventTypeXMLDOM.getNamespacePrefixes().entrySet()) {
            ctx.addPrefix(entry.getKey(), entry.getValue());
        }
        super.setNamespaceContext(ctx);
        super.setExplicitProperties(configurationEventTypeXMLDOM.getXPathProperties().values());
    }

    private void readSchema(String schemaResource) throws IllegalAccessException, InstantiationException, ClassNotFoundException, EPException, URISyntaxException {
        URL url = ResourceLoader.resolveClassPathOrURLResource("schema", schemaResource);
        String uri = url.toURI().toString();
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        registry.addSource(new DOMXSImplementationSourceImpl());
        XSImplementation impl = (XSImplementation)((Object)registry.getDOMImplementation("XS-Loader"));
        XSLoader schemaLoader = impl.createXSLoader(null);
        this.xsModel = schemaLoader.loadURI(uri);
        if (this.xsModel == null) {
            throw new EPException("Failed to read schema via URL '" + schemaResource + '\'');
        }
    }

    protected Class doResolvePropertyType(String property) {
        TypedEventPropertyGetter getter = this.propertyGetterCache.get(property);
        if (getter != null) {
            return getter.getResultClass();
        }
        getter = (TypedEventPropertyGetter)this.doResolvePropertyGetter(property);
        if (getter != null) {
            return getter.getResultClass();
        }
        return null;
    }

    protected EventPropertyGetter doResolvePropertyGetter(String property) {
        TypedEventPropertyGetter getter = this.propertyGetterCache.get(property);
        if (getter != null) {
            return getter;
        }
        try {
            getter = SchemaXMLPropertyParser.parse(property, this.getXPathFactory(), this.getRootElementName(), this.rootElementNamespace, this.xsModel);
            this.propertyGetterCache.put(property, getter);
            return getter;
        }
        catch (XPathExpressionException e) {
            throw new EPException("Error constructing XPath expression from property name '" + property + '\'', e);
        }
    }

    protected String[] doListPropertyNames() {
        return null;
    }
}

