/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.xml;

import antlr.collections.AST;
import com.sun.org.apache.xerces.internal.impl.dv.xs.XSSimpleTypeDecl;
import com.sun.org.apache.xerces.internal.xs.StringList;
import com.sun.org.apache.xerces.internal.xs.XSAttributeUse;
import com.sun.org.apache.xerces.internal.xs.XSComplexTypeDefinition;
import com.sun.org.apache.xerces.internal.xs.XSElementDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSParticle;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.esper.collection.Pair;
import net.esper.eql.generated.EqlTokenTypes;
import net.esper.event.PropertyAccessException;
import net.esper.event.TypedEventPropertyGetter;
import net.esper.event.xml.SchemaUtil;
import net.esper.event.xml.SimpleXMLPropertyParser;
import net.esper.event.xml.XPathNamespaceContext;
import net.esper.event.xml.XPathPropertyGetter;
import net.esper.type.IntValue;
import net.esper.type.StringValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaXMLPropertyParser
implements EqlTokenTypes {
    private static Log log = LogFactory.getLog(SchemaXMLPropertyParser.class);

    public static TypedEventPropertyGetter parse(String propertyName, XPathFactory xPathFactory, String rootElementName, String namespace, XSModel xsModel) throws XPathExpressionException {
        XPathNamespaceContext ctx = new XPathNamespaceContext();
        StringList namespaces = xsModel.getNamespaces();
        for (int i = 0; i < namespaces.getLength(); ++i) {
            ctx.addPrefix("n" + i, namespaces.item(i));
        }
        AST ast = SimpleXMLPropertyParser.parse(propertyName);
        XSElementDeclaration root = SchemaUtil.findRootElement(xsModel, namespace, rootElementName);
        if (root == null) {
            throw new PropertyAccessException("Invalid rootElementName - name must match the rootElement defined in the schema and have the correct namespace");
        }
        if (root.getTypeDefinition().getTypeCategory() != 13) {
            throw new PropertyAccessException("Invalid schema - the root element must have at least either attribute declarations or childs elements");
        }
        XSComplexTypeDefinition complexActualElement = (XSComplexTypeDefinition)root.getTypeDefinition();
        String prefix = ctx.getPrefix(root.getNamespace());
        prefix = prefix == null ? "" : prefix + ':';
        StringBuilder xPathBuf = new StringBuilder();
        xPathBuf.append('/');
        xPathBuf.append(prefix);
        xPathBuf.append(rootElementName);
        Pair<String, QName> pair = null;
        if (ast.getNumberOfChildren() == 1) {
            pair = SchemaXMLPropertyParser.makeProperty(complexActualElement, ast.getFirstChild(), ctx);
            if (pair == null) {
                throw new PropertyAccessException("Failed to locate property '" + propertyName + "' in schema");
            }
            xPathBuf.append(pair.getFirst());
        } else {
            AST child = ast.getFirstChild();
            do {
                XSElementDeclaration decl;
                XSParticle particle;
                if ((pair = SchemaXMLPropertyParser.makeProperty(complexActualElement, child, ctx)) == null) {
                    throw new PropertyAccessException("Failed to locate property '" + propertyName + "' nested property part '" + ((Object)child).toString() + "' in schema");
                }
                String text = child.getFirstChild().getText();
                XSObject obj = SchemaUtil.findPropertyMapping(complexActualElement, text);
                if (obj instanceof XSParticle && (particle = (XSParticle)obj).getTerm() instanceof XSElementDeclaration && (decl = (XSElementDeclaration)particle.getTerm()).getTypeDefinition().getTypeCategory() == 13) {
                    complexActualElement = (XSComplexTypeDefinition)decl.getTypeDefinition();
                }
                xPathBuf.append(pair.getFirst());
            } while ((child = child.getNextSibling()) != null);
        }
        String xPath = xPathBuf.toString();
        if (log.isDebugEnabled()) {
            log.debug(".parse XPath for property '" + propertyName + "' is expression=" + xPath);
        }
        XPath path = xPathFactory.newXPath();
        path.setNamespaceContext(ctx);
        XPathExpression expr = path.compile(xPath);
        return new XPathPropertyGetter(propertyName, expr, pair.getSecond());
    }

    private static Pair<String, QName> makeProperty(XSComplexTypeDefinition parent, AST child, XPathNamespaceContext ctx) {
        String text = child.getFirstChild().getText();
        XSObject obj = SchemaUtil.findPropertyMapping(parent, text);
        if (obj instanceof XSParticle) {
            return SchemaXMLPropertyParser.makeElementProperty((XSParticle)obj, child, ctx);
        }
        if (obj != null) {
            return SchemaXMLPropertyParser.makeAttributeProperty((XSAttributeUse)obj, child, ctx);
        }
        return null;
    }

    private static Pair<String, QName> makeAttributeProperty(XSAttributeUse use, AST child, XPathNamespaceContext ctx) {
        String prefix = ctx.getPrefix(use.getAttrDeclaration().getNamespace());
        prefix = prefix == null ? "" : prefix + ':';
        switch (child.getType()) {
            case 115: 
            case 118: {
                QName type = SchemaUtil.simpleTypeToQName((XSSimpleTypeDecl)use.getAttrDeclaration().getTypeDefinition());
                String path = "/@" + prefix + child.getFirstChild().getText();
                return new Pair<String, QName>(path, type);
            }
            case 116: 
            case 120: {
                throw new RuntimeException("Mapped properties not applicable to attributes");
            }
            case 117: 
            case 119: {
                throw new RuntimeException("Mapped properties not applicable to attributes");
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }

    private static Pair<String, QName> makeElementProperty(XSParticle particle, AST child, XPathNamespaceContext ctx) {
        XSComplexTypeDefinition complex;
        XSElementDeclaration decl = (XSElementDeclaration)particle.getTerm();
        QName type = null;
        type = decl.getTypeDefinition().getTypeCategory() == 14 ? SchemaUtil.simpleTypeToQName((XSSimpleTypeDecl)decl.getTypeDefinition()) : ((complex = (XSComplexTypeDefinition)decl.getTypeDefinition()).getSimpleType() != null ? SchemaUtil.simpleTypeToQName((XSSimpleTypeDecl)complex.getSimpleType()) : XPathConstants.NODE);
        String prefix = ctx.getPrefix(decl.getNamespace());
        prefix = prefix == null ? "" : prefix + ':';
        switch (child.getType()) {
            case 115: {
                if (particle.getMaxOccurs() > 1 || particle.getMaxOccursUnbounded()) {
                    throw new PropertyAccessException("Simple property not allowed in repeating elements");
                }
                return new Pair<String, QName>('/' + prefix + child.getFirstChild().getText(), type);
            }
            case 116: {
                if (particle.getMaxOccurs() <= 1 && !particle.getMaxOccursUnbounded()) {
                    throw new PropertyAccessException("Element " + child.getFirstChild().getText() + " is not a collection, cannot be used as mapped property");
                }
                String key = StringValue.parseString(child.getFirstChild().getNextSibling().getText());
                return new Pair<String, QName>('/' + prefix + child.getFirstChild().getText() + "[@id='" + key + "']", type);
            }
            case 117: {
                if (particle.getMaxOccurs() <= 1 && !particle.getMaxOccursUnbounded()) {
                    throw new PropertyAccessException("Element " + child.getFirstChild().getText() + " is not a collection, cannot be used as mapped property");
                }
                int index = IntValue.parseString(child.getFirstChild().getNextSibling().getText());
                int xPathPosition = index + 1;
                return new Pair<String, QName>('/' + prefix + child.getFirstChild().getText() + "[position() = " + xPathPosition + ']', type);
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }
}

