/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.esper.client.ConfigurationEventTypeXMLDOM;
import net.esper.client.EPException;
import net.esper.event.EventPropertyGetter;
import net.esper.event.TypedEventPropertyGetter;
import net.esper.event.xml.BaseXMLEventType;
import net.esper.event.xml.SimpleXMLPropertyParser;
import net.esper.event.xml.XPathNamespaceContext;
import net.esper.event.xml.XPathPropertyGetter;

public class SimpleXMLEventType
extends BaseXMLEventType {
    private final Map<String, TypedEventPropertyGetter> propertyGetterCache;
    private String defaultNamespacePrefix;
    private final boolean isResolvePropertiesAbsolute;

    public SimpleXMLEventType(ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM) {
        super(configurationEventTypeXMLDOM);
        this.isResolvePropertiesAbsolute = configurationEventTypeXMLDOM.isResolvePropertiesAbsolute();
        XPathNamespaceContext xPathNamespaceContext = new XPathNamespaceContext();
        for (Map.Entry<String, String> entry : configurationEventTypeXMLDOM.getNamespacePrefixes().entrySet()) {
            xPathNamespaceContext.addPrefix(entry.getKey(), entry.getValue());
        }
        if (configurationEventTypeXMLDOM.getDefaultNamespace() != null) {
            String defaultNamespace = configurationEventTypeXMLDOM.getDefaultNamespace();
            xPathNamespaceContext.setDefaultNamespace(defaultNamespace);
            this.defaultNamespacePrefix = null;
            for (Map.Entry<String, String> entry : configurationEventTypeXMLDOM.getNamespacePrefixes().entrySet()) {
                if (!entry.getValue().equals(defaultNamespace)) continue;
                this.defaultNamespacePrefix = entry.getKey();
                break;
            }
        }
        super.setNamespaceContext(xPathNamespaceContext);
        super.setExplicitProperties(configurationEventTypeXMLDOM.getXPathProperties().values());
        this.propertyGetterCache = new HashMap<String, TypedEventPropertyGetter>();
    }

    protected Class doResolvePropertyType(String property) {
        return String.class;
    }

    protected EventPropertyGetter doResolvePropertyGetter(String property) {
        TypedEventPropertyGetter getter = this.propertyGetterCache.get(property);
        if (getter != null) {
            return getter;
        }
        XPathExpression xPathExpression = null;
        try {
            String xPathExpr = SimpleXMLPropertyParser.parse(property, this.getRootElementName(), this.defaultNamespacePrefix, this.isResolvePropertiesAbsolute);
            XPath xpath = this.getXPathFactory().newXPath();
            xpath.setNamespaceContext(this.namespaceContext);
            xPathExpression = xpath.compile(xPathExpr);
        }
        catch (XPathExpressionException e) {
            throw new EPException("Error constructing XPath expression from property name '" + property + '\'', e);
        }
        getter = new XPathPropertyGetter(property, xPathExpression, XPathConstants.STRING);
        this.propertyGetterCache.put(property, getter);
        return getter;
    }
}

