/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.xml;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import net.esper.eql.generated.EQLStatementLexer;
import net.esper.eql.generated.EQLStatementParser;
import net.esper.eql.generated.EqlTokenTypes;
import net.esper.event.PropertyAccessException;
import net.esper.type.IntValue;
import net.esper.type.StringValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleXMLPropertyParser
implements EqlTokenTypes {
    private static final Log log = LogFactory.getLog(SimpleXMLPropertyParser.class);

    public static String parse(String propertyName, String rootElementName, String defaultNamespacePrefix, boolean isResolvePropertiesAbsolute) {
        AST ast = SimpleXMLPropertyParser.parse(propertyName);
        StringBuilder xPathBuf = new StringBuilder();
        xPathBuf.append('/');
        if (isResolvePropertiesAbsolute) {
            if (defaultNamespacePrefix != null) {
                xPathBuf.append(defaultNamespacePrefix);
                xPathBuf.append(':');
            }
            xPathBuf.append(rootElementName);
        }
        if (ast.getNumberOfChildren() == 1) {
            xPathBuf.append(SimpleXMLPropertyParser.makeProperty(ast.getFirstChild(), defaultNamespacePrefix));
        } else {
            AST child = ast.getFirstChild();
            do {
                xPathBuf.append(SimpleXMLPropertyParser.makeProperty(child, defaultNamespacePrefix));
            } while ((child = child.getNextSibling()) != null);
        }
        String xPath = xPathBuf.toString();
        if (log.isDebugEnabled()) {
            log.debug(".parse For property '" + propertyName + "' the xpath is '" + xPath + '\'');
        }
        return xPath;
    }

    private static String makeProperty(AST child, String defaultNamespacePrefix) {
        String prefix = "";
        if (defaultNamespacePrefix != null) {
            prefix = defaultNamespacePrefix + ":";
        }
        switch (child.getType()) {
            case 115: 
            case 118: {
                return '/' + prefix + child.getFirstChild().getText();
            }
            case 116: 
            case 120: {
                String key = StringValue.parseString(child.getFirstChild().getNextSibling().getText());
                return '/' + prefix + child.getFirstChild().getText() + "[@id='" + key + "']";
            }
            case 117: 
            case 119: {
                int index = IntValue.parseString(child.getFirstChild().getNextSibling().getText());
                return '/' + prefix + child.getFirstChild().getText() + "[position() = " + index + ']';
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }

    protected static AST parse(String propertyName) {
        EQLStatementLexer lexer2 = new EQLStatementLexer(new StringReader(propertyName));
        EQLStatementParser parser2 = new EQLStatementParser(lexer2);
        try {
            parser2.startEventPropertyRule();
        }
        catch (TokenStreamException e) {
            throw new PropertyAccessException("Failed to parse property name '" + propertyName + '\'', e);
        }
        catch (RecognitionException e) {
            throw new PropertyAccessException("Failed to parse property name '" + propertyName + '\'', e);
        }
        return parser2.getAST();
    }
}

