/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.filter.EventEvaluator;
import net.esper.filter.FilterHandle;
import net.esper.filter.FilterHandleSetNode;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTypeIndex
implements EventEvaluator {
    private Map<EventType, FilterHandleSetNode> eventTypes = new HashMap<EventType, FilterHandleSetNode>();
    private ReadWriteLock eventTypesRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(EventTypeIndex.class);

    public void destroy() {
        this.eventTypes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EventType eventType, FilterHandleSetNode rootNode) {
        this.eventTypesRWLock.writeLock().lock();
        try {
            if (this.eventTypes.containsKey(eventType)) {
                throw new IllegalStateException("Event type already in index, add not performed, type=" + eventType);
            }
            this.eventTypes.put(eventType, rootNode);
        }
        finally {
            this.eventTypesRWLock.writeLock().unlock();
        }
    }

    public FilterHandleSetNode get(EventType eventType) {
        this.eventTypesRWLock.readLock().lock();
        FilterHandleSetNode result = this.eventTypes.get(eventType);
        this.eventTypesRWLock.readLock().unlock();
        return result;
    }

    @Override
    public void matchEvent(EventBean event, Collection<FilterHandle> matches) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".matchEvent Event received for matching, event=" + event);
        }
        EventType eventType = event.getEventType();
        this.matchType(eventType, event, matches);
        if (eventType.getSuperTypes() == null) {
            return;
        }
        Iterator<EventType> it = eventType.getDeepSuperTypes();
        while (it.hasNext()) {
            EventType superType = it.next();
            this.matchType(superType, event, matches);
        }
    }

    protected int size() {
        return this.eventTypes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchType(EventType eventType, EventBean eventBean, Collection<FilterHandle> matches) {
        this.eventTypesRWLock.readLock().lock();
        FilterHandleSetNode rootNode = null;
        try {
            rootNode = this.eventTypes.get(eventType);
        }
        finally {
            this.eventTypesRWLock.readLock().unlock();
        }
        if (rootNode == null) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                String message = "Event type is not known to the filter service, eventType=" + eventType;
                log.debug(".matchEvent " + message);
            }
            return;
        }
        rootNode.matchEvent(eventBean, matches);
    }
}

