/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.esper.collection.Pair;
import net.esper.event.EventType;
import net.esper.filter.EventTypeIndex;
import net.esper.filter.FilterHandle;
import net.esper.filter.FilterHandleSetNode;
import net.esper.filter.FilterValueSet;
import net.esper.filter.IndexTreeBuilder;
import net.esper.filter.IndexTreePath;

public class EventTypeIndexBuilder {
    private final Map<FilterHandle, Pair<EventType, IndexTreePath>> callbacks;
    private final Lock callbacksLock;
    private final EventTypeIndex eventTypeIndex;

    public EventTypeIndexBuilder(EventTypeIndex eventTypeIndex) {
        this.eventTypeIndex = eventTypeIndex;
        this.callbacks = new HashMap<FilterHandle, Pair<EventType, IndexTreePath>>();
        this.callbacksLock = new ReentrantLock();
    }

    public void destroy() {
        this.callbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(FilterValueSet filterValueSet, FilterHandle filterCallback) {
        EventType eventType = filterValueSet.getEventType();
        FilterHandleSetNode rootNode = this.eventTypeIndex.get(eventType);
        if (rootNode == null) {
            this.callbacksLock.lock();
            try {
                rootNode = this.eventTypeIndex.get(eventType);
                if (rootNode == null) {
                    rootNode = new FilterHandleSetNode();
                    this.eventTypeIndex.add(eventType, rootNode);
                }
            }
            finally {
                this.callbacksLock.unlock();
            }
        }
        this.callbacksLock.lock();
        try {
            if (this.callbacks.containsKey(filterCallback)) {
                throw new IllegalStateException("Callback for filter specification already exists in collection");
            }
        }
        finally {
            this.callbacksLock.unlock();
        }
        IndexTreeBuilder treeBuilder = new IndexTreeBuilder();
        IndexTreePath path = treeBuilder.add(filterValueSet, filterCallback, rootNode);
        this.callbacksLock.lock();
        try {
            this.callbacks.put(filterCallback, new Pair<EventType, IndexTreePath>(eventType, path));
        }
        finally {
            this.callbacksLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(FilterHandle filterCallback) {
        Pair<EventType, IndexTreePath> pair = null;
        this.callbacksLock.lock();
        try {
            pair = this.callbacks.get(filterCallback);
        }
        finally {
            this.callbacksLock.unlock();
        }
        if (pair == null) {
            throw new IllegalArgumentException("Filter callback to be removed not found");
        }
        FilterHandleSetNode rootNode = this.eventTypeIndex.get(pair.getFirst());
        IndexTreeBuilder treeBuilder = new IndexTreeBuilder();
        treeBuilder.remove(filterCallback, pair.getSecond(), rootNode);
        this.callbacksLock.lock();
        try {
            this.callbacks.remove(filterCallback);
        }
        finally {
            this.callbacksLock.unlock();
        }
    }
}

