/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import net.esper.eql.expression.ExprNode;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;

public class ExprNodeAdapter {
    private final ExprNode exprNode;
    private final EventBean[] prototype;
    private final VariableService variableService;
    private ThreadLocal<EventBean[]> arrayPerThread = new ThreadLocal<EventBean[]>(){

        @Override
        protected synchronized EventBean[] initialValue() {
            EventBean[] eventsPerStream = new EventBean[ExprNodeAdapter.this.prototype.length];
            System.arraycopy(ExprNodeAdapter.this.prototype, 0, eventsPerStream, 0, ExprNodeAdapter.this.prototype.length);
            return eventsPerStream;
        }
    };

    public ExprNodeAdapter(ExprNode exprNode, EventBean[] prototype, VariableService variableService) {
        this.exprNode = exprNode;
        this.variableService = variableService;
        this.prototype = prototype == null ? new EventBean[1] : prototype;
    }

    public boolean evaluate(EventBean event) {
        if (this.variableService != null) {
            this.variableService.setLocalVersion();
        }
        EventBean[] eventsPerStream = this.arrayPerThread.get();
        eventsPerStream[0] = event;
        return (Boolean)this.exprNode.evaluate(eventsPerStream, true);
    }
}

