/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FilterOperator {
    EQUAL,
    NOT_EQUAL,
    LESS,
    LESS_OR_EQUAL,
    GREATER_OR_EQUAL,
    GREATER,
    RANGE_OPEN,
    RANGE_CLOSED,
    RANGE_HALF_OPEN,
    RANGE_HALF_CLOSED,
    NOT_RANGE_OPEN,
    NOT_RANGE_CLOSED,
    NOT_RANGE_HALF_OPEN,
    NOT_RANGE_HALF_CLOSED,
    IN_LIST_OF_VALUES,
    NOT_IN_LIST_OF_VALUES,
    BOOLEAN_EXPRESSION;

    private static final String EQUAL_OP = "=";
    private static final String NOT_EQUAL_OP = "!=";
    private static final String LESS_OP = "<";
    private static final String LESS_EQUAL_OP = "<=";
    private static final String GREATER_OP = ">";
    private static final String GREATER_EQUAL_OP = ">=";

    public boolean isRangeOperator() {
        return this == RANGE_CLOSED || this == RANGE_OPEN || this == RANGE_HALF_OPEN || this == RANGE_HALF_CLOSED;
    }

    public boolean isInvertedRangeOperator() {
        return this == NOT_RANGE_CLOSED || this == NOT_RANGE_OPEN || this == NOT_RANGE_HALF_OPEN || this == NOT_RANGE_HALF_CLOSED;
    }

    public boolean isComparisonOperator() {
        return this == LESS || this == LESS_OR_EQUAL || this == GREATER || this == GREATER_OR_EQUAL;
    }

    public static FilterOperator parseComparisonOperator(String operator) {
        if (operator == null) {
            return null;
        }
        if (operator.equals(EQUAL_OP)) {
            return EQUAL;
        }
        if (operator.equals(NOT_EQUAL_OP)) {
            return NOT_EQUAL;
        }
        if (operator.equals(LESS_OP)) {
            return LESS;
        }
        if (operator.equals(LESS_EQUAL_OP)) {
            return LESS_OR_EQUAL;
        }
        if (operator.equals(GREATER_OP)) {
            return GREATER;
        }
        if (operator.equals(GREATER_EQUAL_OP)) {
            return GREATER_OR_EQUAL;
        }
        return null;
    }

    public static FilterOperator parseRangeOperator(boolean isInclusiveFirst, boolean isInclusiveLast, boolean isNot) {
        if (isInclusiveFirst && isInclusiveLast) {
            if (isNot) {
                return NOT_RANGE_CLOSED;
            }
            return RANGE_CLOSED;
        }
        if (isInclusiveFirst && !isInclusiveLast) {
            if (isNot) {
                return NOT_RANGE_HALF_OPEN;
            }
            return RANGE_HALF_OPEN;
        }
        if (isInclusiveLast) {
            if (isNot) {
                return NOT_RANGE_HALF_CLOSED;
            }
            return RANGE_HALF_CLOSED;
        }
        if (isNot) {
            return NOT_RANGE_OPEN;
        }
        return RANGE_OPEN;
    }
}

