/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.filter.EventEvaluator;
import net.esper.filter.ExprNodeAdapter;
import net.esper.filter.FilterHandle;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterParamIndexBase;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterParamIndexBooleanExpr
extends FilterParamIndexBase {
    private final Map<ExprNodeAdapter, EventEvaluator> evaluatorsMap = new HashMap<ExprNodeAdapter, EventEvaluator>();
    private final ReadWriteLock constantsMapRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(FilterParamIndexBooleanExpr.class);

    public FilterParamIndexBooleanExpr(EventType eventType) {
        super(FilterOperator.BOOLEAN_EXPRESSION);
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        ExprNodeAdapter keyValues = (ExprNodeAdapter)filterConstant;
        return this.evaluatorsMap.get(keyValues);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator evaluator) {
        ExprNodeAdapter keys = (ExprNodeAdapter)filterConstant;
        this.evaluatorsMap.put(keys, evaluator);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        ExprNodeAdapter keys = (ExprNodeAdapter)filterConstant;
        return this.evaluatorsMap.remove(keys) != null;
    }

    @Override
    public final int size() {
        return this.evaluatorsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".match (" + Thread.currentThread().getId() + ")");
        }
        ArrayList<EventEvaluator> evaluators = new ArrayList<EventEvaluator>();
        this.constantsMapRWLock.readLock().lock();
        for (ExprNodeAdapter exprNodeAdapter : this.evaluatorsMap.keySet()) {
            if (!exprNodeAdapter.evaluate(eventBean)) continue;
            evaluators.add(this.evaluatorsMap.get(exprNodeAdapter));
        }
        this.constantsMapRWLock.readLock().unlock();
        for (EventEvaluator evaluator : evaluators) {
            evaluator.matchEvent(eventBean, matches);
        }
    }
}

