/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.filter.EventEvaluator;
import net.esper.filter.FilterHandle;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterParamIndexPropBase;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterParamIndexEquals
extends FilterParamIndexPropBase {
    private final Map<Object, EventEvaluator> constantsMap = new HashMap<Object, EventEvaluator>();
    private final ReadWriteLock constantsMapRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(FilterParamIndexEquals.class);

    public FilterParamIndexEquals(String propertyName, EventType eventType) {
        super(propertyName, FilterOperator.EQUAL, eventType);
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        this.checkType(filterConstant);
        return this.constantsMap.get(filterConstant);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator evaluator) {
        this.checkType(filterConstant);
        this.constantsMap.put(filterConstant, evaluator);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        return this.constantsMap.remove(filterConstant) != null;
    }

    @Override
    public final int size() {
        return this.constantsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        Object attributeValue = this.getGetter().get(eventBean);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".match (" + Thread.currentThread().getId() + ") attributeValue=" + attributeValue);
        }
        EventEvaluator evaluator = null;
        this.constantsMapRWLock.readLock().lock();
        try {
            evaluator = this.constantsMap.get(attributeValue);
        }
        finally {
            this.constantsMapRWLock.readLock().unlock();
        }
        if (evaluator == null) {
            return;
        }
        evaluator.matchEvent(eventBean, matches);
    }

    private void checkType(Object filterConstant) {
        if (filterConstant != null && this.getPropertyBoxedType() != filterConstant.getClass()) {
            throw new IllegalArgumentException("Invalid type of filter constant of " + filterConstant.getClass().getName() + " for property " + this.getPropertyName());
        }
    }
}

