/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.filter.DoubleRange;
import net.esper.filter.DoubleRangeComparator;
import net.esper.filter.EventEvaluator;
import net.esper.filter.FilterHandle;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterParamIndexPropBase;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterParamIndexRange
extends FilterParamIndexPropBase {
    private final TreeMap<DoubleRange, EventEvaluator> ranges;
    private final ReadWriteLock rangesRWLock;
    private double largestRangeValueDouble = Double.MIN_VALUE;
    private static final Log log = LogFactory.getLog(FilterParamIndexRange.class);

    public FilterParamIndexRange(String attributeName, FilterOperator filterOperator, EventType eventType) {
        super(attributeName, filterOperator, eventType);
        this.ranges = new TreeMap(new DoubleRangeComparator());
        this.rangesRWLock = new ReentrantReadWriteLock();
        if (!filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Invalid filter operator " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final EventEvaluator get(Object expressionValue) {
        if (!(expressionValue instanceof DoubleRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        return this.ranges.get(expressionValue);
    }

    @Override
    public final void put(Object expressionValue, EventEvaluator matcher) {
        if (!(expressionValue instanceof DoubleRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        DoubleRange range = (DoubleRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            return;
        }
        if (Math.abs(range.getMax() - range.getMin()) > this.largestRangeValueDouble) {
            this.largestRangeValueDouble = Math.abs(range.getMax() - range.getMin());
        }
        this.ranges.put(range, matcher);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        return this.ranges.remove(filterConstant) != null;
    }

    @Override
    public final int size() {
        return this.ranges.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.rangesRWLock;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        Object objAttributeValue = this.getGetter().get(eventBean);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".match Finding range matches, attribute=" + this.getPropertyName() + "  attrValue=" + objAttributeValue);
        }
        if (objAttributeValue == null) {
            return;
        }
        double attributeValue = ((Number)objAttributeValue).doubleValue();
        DoubleRange rangeStart = new DoubleRange(attributeValue - this.largestRangeValueDouble, attributeValue);
        DoubleRange rangeEnd = new DoubleRange(attributeValue, (Double)Double.MAX_VALUE);
        SortedMap<DoubleRange, EventEvaluator> subMap = this.ranges.subMap(rangeStart, rangeEnd);
        if (this.getFilterOperator() == FilterOperator.RANGE_OPEN) {
            for (Map.Entry<DoubleRange, EventEvaluator> entry : subMap.entrySet()) {
                if (!(attributeValue > entry.getKey().getMin()) || !(attributeValue < entry.getKey().getMax())) continue;
                entry.getValue().matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_CLOSED) {
            for (Map.Entry<DoubleRange, EventEvaluator> entry : subMap.entrySet()) {
                if (!(attributeValue >= entry.getKey().getMin()) || !(attributeValue <= entry.getKey().getMax())) continue;
                entry.getValue().matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_HALF_CLOSED) {
            for (Map.Entry<DoubleRange, EventEvaluator> entry : subMap.entrySet()) {
                if (!(attributeValue > entry.getKey().getMin()) || !(attributeValue <= entry.getKey().getMax())) continue;
                entry.getValue().matchEvent(eventBean, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_HALF_OPEN) {
            for (Map.Entry<DoubleRange, EventEvaluator> entry : subMap.entrySet()) {
                if (!(attributeValue >= entry.getKey().getMin()) || !(attributeValue < entry.getKey().getMax())) continue;
                entry.getValue().matchEvent(eventBean, matches);
            }
        } else {
            throw new IllegalStateException("Invalid filter operator " + (Object)((Object)this.getFilterOperator()));
        }
    }
}

