/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.esper.event.EventBean;
import net.esper.filter.EventTypeIndex;
import net.esper.filter.EventTypeIndexBuilder;
import net.esper.filter.FilterHandle;
import net.esper.filter.FilterService;
import net.esper.filter.FilterValueSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterServiceImpl
implements FilterService {
    private final EventTypeIndexBuilder indexBuilder;
    private final EventTypeIndex eventTypeIndex;
    private final AtomicInteger numEventsEvaluated = new AtomicInteger();

    protected FilterServiceImpl() {
        this.eventTypeIndex = new EventTypeIndex();
        this.indexBuilder = new EventTypeIndexBuilder(this.eventTypeIndex);
    }

    @Override
    public void destroy() {
        this.eventTypeIndex.destroy();
        this.indexBuilder.destroy();
    }

    @Override
    public final void add(FilterValueSet filterValueSet, FilterHandle filterCallback) {
        this.indexBuilder.add(filterValueSet, filterCallback);
    }

    @Override
    public final void remove(FilterHandle filterCallback) {
        this.indexBuilder.remove(filterCallback);
    }

    @Override
    public final void evaluate(EventBean eventBean, Collection<FilterHandle> matches) {
        this.numEventsEvaluated.incrementAndGet();
        this.eventTypeIndex.matchEvent(eventBean, matches);
    }

    @Override
    public final int getNumEventsEvaluated() {
        return this.numEventsEvaluated.get();
    }
}

