/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.esper.event.EventType;
import net.esper.filter.FilterSpecParam;
import net.esper.filter.FilterValueSet;
import net.esper.filter.FilterValueSetImpl;
import net.esper.filter.FilterValueSetParam;
import net.esper.filter.FilterValueSetParamImpl;
import net.esper.pattern.MatchedEventMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterSpecCompiled {
    private final EventType eventType;
    private final List<FilterSpecParam> parameters;

    public FilterSpecCompiled(EventType eventType, List<FilterSpecParam> parameters) {
        this.eventType = eventType;
        this.parameters = parameters;
    }

    public final EventType getEventType() {
        return this.eventType;
    }

    public final List<FilterSpecParam> getParameters() {
        return this.parameters;
    }

    public FilterValueSet getValueSet(MatchedEventMap matchedEvents) {
        LinkedList<FilterValueSetParam> valueList = new LinkedList<FilterValueSetParam>();
        for (FilterSpecParam specParam : this.parameters) {
            Object filterForValue = specParam.getFilterValue(matchedEvents);
            FilterValueSetParamImpl valueParam = new FilterValueSetParamImpl(specParam.getPropertyName(), specParam.getFilterOperator(), filterForValue);
            valueList.add(valueParam);
        }
        return new FilterValueSetImpl(this.eventType, valueList);
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecCompiled type=" + this.eventType);
        buffer.append(" parameters=" + Arrays.toString(this.parameters.toArray()));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecCompiled)) {
            return false;
        }
        FilterSpecCompiled other = (FilterSpecCompiled)obj;
        if (this.eventType != other.eventType) {
            return false;
        }
        if (this.parameters.size() != other.parameters.size()) {
            return false;
        }
        Iterator<FilterSpecParam> iterOne = this.parameters.iterator();
        Iterator<FilterSpecParam> iterOther = other.parameters.iterator();
        while (iterOne.hasNext()) {
            if (iterOne.next().equals(iterOther.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.eventType.hashCode();
        for (FilterSpecParam param : this.parameters) {
            hashCode ^= param.getPropertyName().hashCode();
        }
        return hashCode;
    }
}

