/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.esper.collection.Pair;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprAndNode;
import net.esper.eql.expression.ExprBetweenNode;
import net.esper.eql.expression.ExprConstantNode;
import net.esper.eql.expression.ExprEqualsNode;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprInNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprNodeSubselectVisitor;
import net.esper.eql.expression.ExprRelationalOpNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventType;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterParamExprMap;
import net.esper.filter.FilterSpecCompiled;
import net.esper.filter.FilterSpecParam;
import net.esper.filter.FilterSpecParamConstant;
import net.esper.filter.FilterSpecParamEventProp;
import net.esper.filter.FilterSpecParamExprNode;
import net.esper.filter.FilterSpecParamIn;
import net.esper.filter.FilterSpecParamInValue;
import net.esper.filter.FilterSpecParamRange;
import net.esper.filter.FilterSpecParamRangeValue;
import net.esper.filter.InSetOfValuesConstant;
import net.esper.filter.InSetOfValuesEventProp;
import net.esper.filter.RangeValueDouble;
import net.esper.filter.RangeValueEventProp;
import net.esper.schedule.TimeProvider;
import net.esper.type.RelationalOpEnum;
import net.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterSpecCompiler {
    private static final Log log = LogFactory.getLog(FilterSpecCompiler.class);
    public static final String PROPERTY_NAME_BOOLEAN_EXPRESSION = ".boolean_expression";

    public static FilterSpecCompiled makeFilterSpec(EventType eventType, List<ExprNode> filterExpessions, LinkedHashMap<String, EventType> taggedEventTypes, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        List<ExprNode> constituents = FilterSpecCompiler.validateAndDecompose(filterExpessions, streamTypeService, methodResolutionService, timeProvider, variableService);
        FilterSpecCompiled spec = FilterSpecCompiler.makeFilterSpec(eventType, constituents, taggedEventTypes, variableService);
        if (log.isDebugEnabled()) {
            log.debug(".makeFilterSpec spec=" + spec);
        }
        return spec;
    }

    private static void consolidate(List<FilterSpecParam> items, FilterParamExprMap filterParamExprMap) {
        FilterOperator op = items.get(0).getFilterOperator();
        if (op == FilterOperator.NOT_EQUAL) {
            FilterSpecCompiler.handleConsolidateNotEqual(items, filterParamExprMap);
        } else {
            for (int i = 1; i < items.size(); ++i) {
                filterParamExprMap.removeValue(items.get(i));
            }
        }
    }

    public static List<ExprNode> validateDisallowSubquery(List<ExprNode> exprNodes, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        ArrayList<ExprNode> validatedNodes = new ArrayList<ExprNode>();
        for (ExprNode node : exprNodes) {
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            node.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within filters");
            }
            ExprNode validated = node.getValidatedSubtree(streamTypeService, methodResolutionService, null, timeProvider, variableService);
            validatedNodes.add(validated);
            if (validated.getType() == Boolean.class || validated.getType() == Boolean.TYPE) continue;
            throw new ExprValidationException("Filter expression not returning a boolean value: '" + validated.toExpressionString() + "'");
        }
        return validatedNodes;
    }

    private static List<ExprNode> validateAndDecompose(List<ExprNode> exprNodes, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        List<ExprNode> validatedNodes = FilterSpecCompiler.validateDisallowSubquery(exprNodes, streamTypeService, methodResolutionService, timeProvider, variableService);
        ArrayList<ExprNode> constituents = new ArrayList<ExprNode>();
        for (ExprNode validated : validatedNodes) {
            if (validated instanceof ExprAndNode) {
                FilterSpecCompiler.recursiveAndConstituents(constituents, validated);
            } else {
                constituents.add(validated);
            }
            LinkedList<ExprAggregateNode> aggregateExprNodes = new LinkedList<ExprAggregateNode>();
            ExprAggregateNode.getAggregatesBottomUp(validated, aggregateExprNodes);
            if (aggregateExprNodes.isEmpty()) continue;
            throw new ExprValidationException("Aggregation functions not allowed within filters");
        }
        return constituents;
    }

    private static void consolidate(FilterParamExprMap filterParamExprMap) {
        boolean haveConsolidated;
        HashMap<Pair<String, FilterOperator>, ArrayList<FilterSpecParam>> mapOfParams = new HashMap<Pair<String, FilterOperator>, ArrayList<FilterSpecParam>>();
        do {
            haveConsolidated = false;
            mapOfParams.clear();
            for (FilterSpecParam currentParam : filterParamExprMap.getFilterParams()) {
                FilterOperator op;
                String propName = currentParam.getPropertyName();
                Pair<String, FilterOperator> key = new Pair<String, FilterOperator>(propName, op = currentParam.getFilterOperator());
                ArrayList<FilterSpecParam> existingParam = (ArrayList<FilterSpecParam>)mapOfParams.get(key);
                if (existingParam == null) {
                    existingParam = new ArrayList<FilterSpecParam>();
                    mapOfParams.put(key, existingParam);
                }
                existingParam.add(currentParam);
            }
            for (List entry : mapOfParams.values()) {
                if (entry.size() <= 1) continue;
                haveConsolidated = true;
                FilterSpecCompiler.consolidate(entry, filterParamExprMap);
            }
        } while (haveConsolidated);
    }

    private static FilterSpecCompiled makeFilterSpec(EventType eventType, List<ExprNode> constituents, LinkedHashMap<String, EventType> taggedEventTypes, VariableService variableService) throws ExprValidationException {
        FilterParamExprMap filterParamExprMap = new FilterParamExprMap();
        for (ExprNode constituent : constituents) {
            FilterSpecParam param = FilterSpecCompiler.makeFilterParam(constituent);
            filterParamExprMap.put(constituent, param);
        }
        FilterSpecCompiler.consolidate(filterParamExprMap);
        ArrayList<FilterSpecParam> filterParams = new ArrayList<FilterSpecParam>();
        filterParams.addAll(filterParamExprMap.getFilterParams());
        List<ExprNode> remainingExprNodes = filterParamExprMap.getUnassignedExpressions();
        ExprNode exprNode = null;
        if (!remainingExprNodes.isEmpty()) {
            if (remainingExprNodes.size() == 1) {
                exprNode = remainingExprNodes.get(0);
            } else {
                ExprAndNode andNode = new ExprAndNode();
                for (ExprNode unoptimized : remainingExprNodes) {
                    andNode.addChildNode(unoptimized);
                }
                exprNode = andNode;
            }
        }
        if (exprNode != null) {
            FilterSpecParamExprNode param = new FilterSpecParamExprNode(PROPERTY_NAME_BOOLEAN_EXPRESSION, FilterOperator.BOOLEAN_EXPRESSION, exprNode, taggedEventTypes, variableService);
            filterParams.add(param);
        }
        return new FilterSpecCompiled(eventType, filterParams);
    }

    private static void handleConsolidateNotEqual(List<FilterSpecParam> params, FilterParamExprMap filterParamExprMap) {
        ArrayList<FilterSpecParamInValue> values = new ArrayList<FilterSpecParamInValue>();
        ExprNode lastNotEqualsExprNode = null;
        for (FilterSpecParam param : params) {
            if (param instanceof FilterSpecParamConstant) {
                FilterSpecParamConstant constantParam = (FilterSpecParamConstant)param;
                Object constant = constantParam.getFilterConstant();
                values.add(new InSetOfValuesConstant(constant));
            } else if (param instanceof FilterSpecParamEventProp) {
                FilterSpecParamEventProp eventProp = (FilterSpecParamEventProp)param;
                values.add(new InSetOfValuesEventProp(eventProp.getResultEventAsName(), eventProp.getResultEventProperty(), eventProp.isMustCoerce(), eventProp.getCoercionType()));
            } else {
                throw new IllegalArgumentException("Unknown filter parameter:" + param.toString());
            }
            lastNotEqualsExprNode = filterParamExprMap.removeEntry(param);
        }
        FilterSpecParamIn param = new FilterSpecParamIn(params.get(0).getPropertyName(), FilterOperator.NOT_IN_LIST_OF_VALUES, values);
        filterParamExprMap.put(lastNotEqualsExprNode, param);
    }

    protected static FilterSpecParam makeFilterParam(ExprNode constituent) throws ExprValidationException {
        FilterSpecParam param;
        if ((constituent instanceof ExprEqualsNode || constituent instanceof ExprRelationalOpNode) && (param = FilterSpecCompiler.handleEqualsAndRelOp(constituent)) != null) {
            return param;
        }
        if (constituent instanceof ExprInNode && (param = FilterSpecCompiler.handleInSetNode((ExprInNode)constituent)) != null) {
            return param;
        }
        if (constituent instanceof ExprBetweenNode && (param = FilterSpecCompiler.handleRangeNode((ExprBetweenNode)constituent)) != null) {
            return param;
        }
        return null;
    }

    private static FilterSpecParam handleRangeNode(ExprBetweenNode betweenNode) {
        ExprNode left = betweenNode.getChildNodes().get(0);
        if (left instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)left;
            String propertyName = identNode.getResolvedPropertyName();
            FilterOperator op = FilterOperator.parseRangeOperator(betweenNode.isLowEndpointIncluded(), betweenNode.isHighEndpointIncluded(), betweenNode.isNotBetween());
            FilterSpecParamRangeValue low = FilterSpecCompiler.handleRangeNodeEndpoint(betweenNode.getChildNodes().get(1));
            FilterSpecParamRangeValue high = FilterSpecCompiler.handleRangeNodeEndpoint(betweenNode.getChildNodes().get(2));
            if (low != null && high != null) {
                return new FilterSpecParamRange(propertyName, op, low, high);
            }
        }
        return null;
    }

    private static FilterSpecParamRangeValue handleRangeNodeEndpoint(ExprNode endpoint) {
        if (endpoint instanceof ExprConstantNode) {
            ExprConstantNode node = (ExprConstantNode)endpoint;
            Number result = (Number)node.evaluate(null, true);
            return new RangeValueDouble(result.doubleValue());
        }
        if (endpoint instanceof ExprIdentNode) {
            ExprIdentNode identNodeInner = (ExprIdentNode)endpoint;
            if (identNodeInner.getStreamId() == 0) {
                return null;
            }
            return new RangeValueEventProp(identNodeInner.getResolvedStreamName(), identNodeInner.getResolvedPropertyName());
        }
        return null;
    }

    private static FilterSpecParam handleInSetNode(ExprInNode constituent) throws ExprValidationException {
        ExprNode left = constituent.getChildNodes().get(0);
        if (left instanceof ExprIdentNode) {
            ExprIdentNode identNodeInSet = (ExprIdentNode)left;
            String propertyName = identNodeInSet.getResolvedPropertyName();
            FilterOperator op = FilterOperator.IN_LIST_OF_VALUES;
            if (constituent.isNotIn()) {
                op = FilterOperator.NOT_IN_LIST_OF_VALUES;
            }
            ArrayList<FilterSpecParamInValue> listofValues = new ArrayList<FilterSpecParamInValue>();
            Iterator it = constituent.getChildNodes().iterator();
            it.next();
            while (it.hasNext()) {
                ExprNode subNode = (ExprNode)it.next();
                if (subNode instanceof ExprConstantNode) {
                    ExprConstantNode constantNode = (ExprConstantNode)subNode;
                    Object constant = constantNode.evaluate(null, true);
                    constant = FilterSpecCompiler.handleConstantsCoercion(identNodeInSet, constant);
                    listofValues.add(new InSetOfValuesConstant(constant));
                }
                if (!(subNode instanceof ExprIdentNode)) continue;
                ExprIdentNode identNodeInner = (ExprIdentNode)subNode;
                if (identNodeInner.getStreamId() == 0) break;
                boolean isMustCoerce = false;
                Class numericCoercionType = identNodeInSet.getType();
                if (identNodeInner.getType() != identNodeInSet.getType() && JavaClassHelper.isNumeric(identNodeInSet.getType())) {
                    if (!JavaClassHelper.canCoerce(identNodeInner.getType(), identNodeInSet.getType())) {
                        FilterSpecCompiler.throwConversionError(identNodeInner.getType(), identNodeInSet.getType(), identNodeInSet.getResolvedPropertyName());
                    }
                    isMustCoerce = true;
                }
                listofValues.add(new InSetOfValuesEventProp(identNodeInner.getResolvedStreamName(), identNodeInner.getResolvedPropertyName(), isMustCoerce, numericCoercionType));
            }
            if (listofValues.size() == constituent.getChildNodes().size() - 1) {
                return new FilterSpecParamIn(propertyName, op, listofValues);
            }
        }
        return null;
    }

    private static FilterSpecParam handleEqualsAndRelOp(ExprNode constituent) throws ExprValidationException {
        FilterOperator op;
        if (constituent instanceof ExprEqualsNode) {
            op = FilterOperator.EQUAL;
            if (((ExprEqualsNode)constituent).isNotEquals()) {
                op = FilterOperator.NOT_EQUAL;
            }
        } else {
            ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
            if (relNode.getRelationalOpEnum() == RelationalOpEnum.GT) {
                op = FilterOperator.GREATER;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LT) {
                op = FilterOperator.LESS;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LE) {
                op = FilterOperator.LESS_OR_EQUAL;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.GE) {
                op = FilterOperator.GREATER_OR_EQUAL;
            } else {
                throw new IllegalStateException("Opertor '" + (Object)((Object)relNode.getRelationalOpEnum()) + "' not mapped");
            }
        }
        ExprNode left = constituent.getChildNodes().get(0);
        ExprNode right = constituent.getChildNodes().get(1);
        if (right instanceof ExprConstantNode && left instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)left;
            ExprConstantNode constantNode = (ExprConstantNode)right;
            String propertyName = identNode.getResolvedPropertyName();
            Object constant = constantNode.evaluate(null, true);
            constant = FilterSpecCompiler.handleConstantsCoercion(identNode, constant);
            return new FilterSpecParamConstant(propertyName, op, constant);
        }
        if (left instanceof ExprConstantNode && right instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)right;
            ExprConstantNode constantNode = (ExprConstantNode)left;
            String propertyName = identNode.getResolvedPropertyName();
            Object constant = constantNode.evaluate(null, true);
            constant = FilterSpecCompiler.handleConstantsCoercion(identNode, constant);
            return new FilterSpecParamConstant(propertyName, op, constant);
        }
        if (left instanceof ExprIdentNode && right instanceof ExprIdentNode) {
            ExprIdentNode identNodeLeft = (ExprIdentNode)left;
            ExprIdentNode identNodeRight = (ExprIdentNode)right;
            if (identNodeLeft.getStreamId() == 0 && identNodeRight.getStreamId() != 0) {
                return FilterSpecCompiler.handleProperty(op, identNodeLeft, identNodeRight);
            }
            if (identNodeRight.getStreamId() == 0 && identNodeLeft.getStreamId() != 0) {
                return FilterSpecCompiler.handleProperty(op, identNodeRight, identNodeLeft);
            }
        }
        return null;
    }

    private static FilterSpecParamEventProp handleProperty(FilterOperator op, ExprIdentNode identNodeLeft, ExprIdentNode identNodeRight) throws ExprValidationException {
        String propertyName = identNodeLeft.getResolvedPropertyName();
        boolean isMustCoerce = false;
        Class numericCoercionType = identNodeLeft.getType();
        if (identNodeRight.getType() != identNodeLeft.getType() && JavaClassHelper.isNumeric(identNodeRight.getType())) {
            if (!JavaClassHelper.canCoerce(identNodeRight.getType(), identNodeLeft.getType())) {
                FilterSpecCompiler.throwConversionError(identNodeRight.getType(), identNodeLeft.getType(), identNodeLeft.getResolvedPropertyName());
            }
            isMustCoerce = true;
        }
        return new FilterSpecParamEventProp(propertyName, op, identNodeRight.getResolvedStreamName(), identNodeRight.getResolvedPropertyName(), isMustCoerce, numericCoercionType);
    }

    private static void throwConversionError(Class fromType, Class toType, String propertyName) throws ExprValidationException {
        String text = "Implicit conversion from datatype '" + fromType.getSimpleName() + "' to '" + toType.getSimpleName() + "' for property '" + propertyName + "' is not allowed (strict filter type coercion)";
        throw new ExprValidationException(text);
    }

    private static Object handleConstantsCoercion(ExprIdentNode identNode, Object constant) throws ExprValidationException {
        Class identNodeType = identNode.getType();
        if (!JavaClassHelper.isNumeric(identNodeType)) {
            return constant;
        }
        if (constant == null) {
            return null;
        }
        if (!JavaClassHelper.canCoerce(constant.getClass(), identNodeType)) {
            FilterSpecCompiler.throwConversionError(constant.getClass(), identNodeType, identNode.getResolvedPropertyName());
        }
        Class identNodeTypeBoxed = JavaClassHelper.getBoxedType(identNodeType);
        return JavaClassHelper.coerceBoxed((Number)constant, identNodeTypeBoxed);
    }

    private static void recursiveAndConstituents(List<ExprNode> constituents, ExprNode exprNode) {
        for (ExprNode inner : exprNode.getChildNodes()) {
            if (inner instanceof ExprAndNode) {
                FilterSpecCompiler.recursiveAndConstituents(constituents, inner);
                continue;
            }
            constituents.add(inner);
        }
    }
}

