/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import net.esper.event.EventBean;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterSpecParam;
import net.esper.pattern.MatchedEventMap;
import net.esper.util.JavaClassHelper;

public final class FilterSpecParamEventProp
extends FilterSpecParam {
    private final String resultEventAsName;
    private final String resultEventProperty;
    private final boolean isMustCoerce;
    private final Class coercionType;

    public FilterSpecParamEventProp(String propertyName, FilterOperator filterOperator, String resultEventAsName, String resultEventProperty, boolean isMustCoerce, Class coercionType) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        this.resultEventAsName = resultEventAsName;
        this.resultEventProperty = resultEventProperty;
        this.isMustCoerce = isMustCoerce;
        this.coercionType = coercionType;
        if (filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "event property filter parameter");
        }
    }

    public boolean isMustCoerce() {
        return this.isMustCoerce;
    }

    public Class getCoercionType() {
        return this.coercionType;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public Object getFilterValue(MatchedEventMap matchedEvents) {
        EventBean event = matchedEvents.getMatchingEvent(this.resultEventAsName);
        if (event == null) {
            throw new IllegalStateException("Event named ''" + this.resultEventAsName + "' not found in event pattern result set");
        }
        Object value = event.get(this.resultEventProperty);
        if (this.isMustCoerce) {
            value = JavaClassHelper.coerceBoxed((Number)value, this.coercionType);
        }
        return value;
    }

    public final String toString() {
        return super.toString() + " resultEventAsName=" + this.resultEventAsName + " resultEventProperty=" + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamEventProp)) {
            return false;
        }
        FilterSpecParamEventProp other = (FilterSpecParamEventProp)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.resultEventAsName.equals(other.resultEventAsName) && this.resultEventProperty.equals(other.resultEventProperty);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.resultEventProperty.hashCode();
        return result;
    }
}

