/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.LinkedHashMap;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprNodeVariableVisitor;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.filter.ExprNodeAdapter;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterSpecParam;
import net.esper.pattern.MatchedEventMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterSpecParamExprNode
extends FilterSpecParam {
    private final ExprNode exprNode;
    private final LinkedHashMap<String, EventType> taggedEventTypes;
    private final VariableService variableService;
    private final boolean hasVariable;

    public FilterSpecParamExprNode(String propertyName, FilterOperator filterOperator, ExprNode exprNode, LinkedHashMap<String, EventType> taggedEventTypes, VariableService variableService) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        if (filterOperator != FilterOperator.BOOLEAN_EXPRESSION) {
            throw new IllegalArgumentException("Invalid filter operator for filter expression node");
        }
        this.exprNode = exprNode;
        this.taggedEventTypes = taggedEventTypes;
        this.variableService = variableService;
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor();
        exprNode.accept(visitor);
        this.hasVariable = visitor.isHasVariables();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }

    public LinkedHashMap<String, EventType> getTaggedEventTypes() {
        return this.taggedEventTypes;
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents) {
        EventBean[] events = null;
        if (this.taggedEventTypes != null) {
            events = new EventBean[this.taggedEventTypes.size() + 1];
            int count = 1;
            for (String tag : this.taggedEventTypes.keySet()) {
                events[count] = matchedEvents.getMatchingEvent(tag);
                ++count;
            }
        }
        if (this.hasVariable) {
            return new ExprNodeAdapter(this.exprNode, events, this.variableService);
        }
        return new ExprNodeAdapter(this.exprNode, events, null);
    }

    @Override
    public final String toString() {
        return super.toString() + "  exprNode=" + this.exprNode.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamExprNode)) {
            return false;
        }
        FilterSpecParamExprNode other = (FilterSpecParamExprNode)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.exprNode == other.exprNode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.exprNode.hashCode();
        return result;
    }
}

