/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.Arrays;
import java.util.List;
import net.esper.collection.MultiKeyUntyped;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterSpecParam;
import net.esper.filter.FilterSpecParamInValue;
import net.esper.filter.InSetOfValuesEventProp;
import net.esper.pattern.MatchedEventMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterSpecParamIn
extends FilterSpecParam {
    private final List<FilterSpecParamInValue> listOfValues;
    private MultiKeyUntyped inListConstantsOnly;

    public FilterSpecParamIn(String propertyName, FilterOperator filterOperator, List<FilterSpecParamInValue> listofValues) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        this.listOfValues = listofValues;
        boolean isAllConstants = false;
        for (FilterSpecParamInValue value : listofValues) {
            if (!(value instanceof InSetOfValuesEventProp)) continue;
            isAllConstants = false;
            break;
        }
        if (isAllConstants) {
            Object[] constants = new Object[this.listOfValues.size()];
            int count = 0;
            for (FilterSpecParamInValue valuePlaceholder : this.listOfValues) {
                constants[count++] = valuePlaceholder.getFilterValue(null);
            }
            this.inListConstantsOnly = new MultiKeyUntyped(constants);
        }
        if (filterOperator != FilterOperator.IN_LIST_OF_VALUES && filterOperator != FilterOperator.NOT_IN_LIST_OF_VALUES) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "in-values filter parameter");
        }
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents) {
        if (this.inListConstantsOnly != null) {
            return this.inListConstantsOnly;
        }
        Object[] actualValues = new Object[this.listOfValues.size()];
        int count = 0;
        for (FilterSpecParamInValue valuePlaceholder : this.listOfValues) {
            actualValues[count++] = valuePlaceholder.getFilterValue(matchedEvents);
        }
        return new MultiKeyUntyped(actualValues);
    }

    public List<FilterSpecParamInValue> getListOfValues() {
        return this.listOfValues;
    }

    @Override
    public final String toString() {
        return super.toString() + "  in=(listOfValues=" + this.listOfValues.toString() + ')';
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamIn)) {
            return false;
        }
        FilterSpecParamIn other = (FilterSpecParamIn)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.listOfValues.size() != other.listOfValues.size()) {
            return false;
        }
        return Arrays.deepEquals(this.listOfValues.toArray(), other.listOfValues.toArray());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.listOfValues != null ? ((Object)this.listOfValues).hashCode() : 0);
        return result;
    }
}

