/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import net.esper.filter.DoubleRange;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterSpecParam;
import net.esper.filter.FilterSpecParamRangeValue;
import net.esper.pattern.MatchedEventMap;

public final class FilterSpecParamRange
extends FilterSpecParam {
    private final FilterSpecParamRangeValue min;
    private final FilterSpecParamRangeValue max;

    public FilterSpecParamRange(String propertyName, FilterOperator filterOperator, FilterSpecParamRangeValue min, FilterSpecParamRangeValue max) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        this.min = min;
        this.max = max;
        if (!filterOperator.isRangeOperator() && !filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "range filter parameter");
        }
    }

    public final Object getFilterValue(MatchedEventMap matchedEvents) {
        Double begin = this.min.getFilterValue(matchedEvents);
        Double end = this.max.getFilterValue(matchedEvents);
        return new DoubleRange(begin, end);
    }

    public FilterSpecParamRangeValue getMin() {
        return this.min;
    }

    public FilterSpecParamRangeValue getMax() {
        return this.max;
    }

    public final String toString() {
        return super.toString() + "  range=(min=" + this.min.toString() + ",max=" + this.max.toString() + ')';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamRange)) {
            return false;
        }
        FilterSpecParamRange other = (FilterSpecParamRange)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.min.equals(other.min) && this.max.equals(other.max);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        return result;
    }
}

