/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import net.esper.event.EventBean;
import net.esper.filter.FilterSpecParamInValue;
import net.esper.pattern.MatchedEventMap;
import net.esper.util.JavaClassHelper;

public class InSetOfValuesEventProp
implements FilterSpecParamInValue {
    private final String resultEventAsName;
    private final String resultEventProperty;
    private final boolean isMustCoerce;
    private final Class coercionType;

    public InSetOfValuesEventProp(String resultEventAsName, String resultEventProperty, boolean isMustCoerce, Class coercionType) {
        this.resultEventAsName = resultEventAsName;
        this.resultEventProperty = resultEventProperty;
        this.coercionType = coercionType;
        this.isMustCoerce = isMustCoerce;
    }

    public final Object getFilterValue(MatchedEventMap matchedEvents) {
        EventBean event = matchedEvents.getMatchingEvent(this.resultEventAsName);
        if (event == null) {
            throw new IllegalStateException("Matching event named '" + this.resultEventAsName + "' not found in event result set");
        }
        Object value = event.get(this.resultEventProperty);
        if (this.isMustCoerce) {
            value = JavaClassHelper.coerceBoxed((Number)value, this.coercionType);
        }
        return value;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public final String toString() {
        return "resultEventProp=" + this.resultEventAsName + '.' + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InSetOfValuesEventProp)) {
            return false;
        }
        InSetOfValuesEventProp other = (InSetOfValuesEventProp)obj;
        return other.resultEventAsName.equals(this.resultEventAsName) && other.resultEventProperty.equals(this.resultEventProperty);
    }

    public int hashCode() {
        return this.resultEventProperty.hashCode();
    }
}

