/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import net.esper.event.EventType;
import net.esper.filter.FilterOperator;
import net.esper.filter.FilterParamIndexBase;
import net.esper.filter.FilterParamIndexBooleanExpr;
import net.esper.filter.FilterParamIndexCompare;
import net.esper.filter.FilterParamIndexEquals;
import net.esper.filter.FilterParamIndexIn;
import net.esper.filter.FilterParamIndexNotEquals;
import net.esper.filter.FilterParamIndexNotIn;
import net.esper.filter.FilterParamIndexNotRange;
import net.esper.filter.FilterParamIndexRange;

public class IndexFactory {
    public static FilterParamIndexBase createIndex(EventType eventType, String propertyName, FilterOperator filterOperator) {
        if (filterOperator == FilterOperator.EQUAL) {
            FilterParamIndexEquals index = new FilterParamIndexEquals(propertyName, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.NOT_EQUAL) {
            FilterParamIndexNotEquals index = new FilterParamIndexNotEquals(propertyName, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.GREATER || filterOperator == FilterOperator.GREATER_OR_EQUAL || filterOperator == FilterOperator.LESS || filterOperator == FilterOperator.LESS_OR_EQUAL) {
            FilterParamIndexCompare index = new FilterParamIndexCompare(propertyName, filterOperator, eventType);
            return index;
        }
        if (filterOperator.isRangeOperator()) {
            FilterParamIndexRange index = new FilterParamIndexRange(propertyName, filterOperator, eventType);
            return index;
        }
        if (filterOperator.isInvertedRangeOperator()) {
            FilterParamIndexNotRange index = new FilterParamIndexNotRange(propertyName, filterOperator, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.IN_LIST_OF_VALUES) {
            FilterParamIndexIn index = new FilterParamIndexIn(propertyName, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.NOT_IN_LIST_OF_VALUES) {
            FilterParamIndexNotIn index = new FilterParamIndexNotIn(propertyName, eventType);
            return index;
        }
        if (filterOperator == FilterOperator.BOOLEAN_EXPRESSION) {
            FilterParamIndexBooleanExpr index = new FilterParamIndexBooleanExpr(eventType);
            return index;
        }
        throw new IllegalArgumentException("Cannot create filter index instance for filter operator " + (Object)((Object)filterOperator));
    }
}

