/*
 * Decompiled with CFR 0.152.
 */
package net.esper.filter;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.esper.collection.Pair;
import net.esper.event.EventType;
import net.esper.filter.EventEvaluator;
import net.esper.filter.FilterHandle;
import net.esper.filter.FilterHandleSetNode;
import net.esper.filter.FilterParamIndexBase;
import net.esper.filter.FilterValueSet;
import net.esper.filter.FilterValueSetParam;
import net.esper.filter.FilterValueSetParamComparator;
import net.esper.filter.IndexFactory;
import net.esper.filter.IndexHelper;
import net.esper.filter.IndexTreePath;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexTreeBuilder {
    private EventType eventType;
    private SortedSet<FilterValueSetParam> remainingParameters;
    private FilterHandle filterCallback;
    private long currentThreadId;
    private static final Log log = LogFactory.getLog(IndexTreeBuilder.class);

    public final IndexTreePath add(FilterValueSet filterValueSet, FilterHandle filterCallback, FilterHandleSetNode topNode) {
        this.eventType = filterValueSet.getEventType();
        this.remainingParameters = IndexTreeBuilder.copySortParameters(filterValueSet.getParameters());
        this.filterCallback = filterCallback;
        this.currentThreadId = Thread.currentThread().getId();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".add (" + this.currentThreadId + ") Adding filter callback, " + "  topNode=" + topNode + "  filterCallback=" + this.filterCallback);
        }
        IndexTreePath treePathInfo = new IndexTreePath();
        this.addToNode(topNode, treePathInfo);
        this.remainingParameters = null;
        this.filterCallback = null;
        return treePathInfo;
    }

    public final void remove(FilterHandle filterCallback, IndexTreePath treePathInfo, FilterHandleSetNode topNode) {
        this.remainingParameters = null;
        this.filterCallback = filterCallback;
        this.currentThreadId = Thread.currentThread().getId();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".remove (" + this.currentThreadId + ") Removing filterCallback " + " from treepath=" + treePathInfo.toString() + "  topNode=" + topNode + "  filterCallback=" + filterCallback);
        }
        this.removeFromNode(topNode, treePathInfo);
        this.filterCallback = null;
    }

    private void addToNode(FilterHandleSetNode currentNode, IndexTreePath treePathInfo) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".addToNode (" + this.currentThreadId + ") Adding filterCallback, node=" + currentNode + "  remainingParameters=" + this.printRemainingParameters());
        }
        if (this.remainingParameters.isEmpty()) {
            currentNode.getNodeRWLock().writeLock().lock();
            currentNode.add(this.filterCallback);
            currentNode.getNodeRWLock().writeLock().unlock();
            return;
        }
        currentNode.getNodeRWLock().readLock().lock();
        Pair<FilterValueSetParam, FilterParamIndexBase> pair = IndexHelper.findIndex(this.remainingParameters, currentNode.getIndizes());
        if (pair != null) {
            this.remainingParameters.remove(pair.getFirst());
            Object filterForValue = pair.getFirst().getFilterForValue();
            FilterParamIndexBase index = pair.getSecond();
            treePathInfo.add(index, filterForValue);
            this.addToIndex(index, filterForValue, treePathInfo);
            currentNode.getNodeRWLock().readLock().unlock();
            return;
        }
        currentNode.getNodeRWLock().readLock().unlock();
        currentNode.getNodeRWLock().writeLock().lock();
        pair = IndexHelper.findIndex(this.remainingParameters, currentNode.getIndizes());
        if (pair != null) {
            this.remainingParameters.remove(pair.getFirst());
            Object filterForValue = pair.getFirst().getFilterForValue();
            FilterParamIndexBase index = pair.getSecond();
            treePathInfo.add(index, filterForValue);
            this.addToIndex(index, filterForValue, treePathInfo);
            currentNode.getNodeRWLock().writeLock().unlock();
            return;
        }
        FilterValueSetParam parameterPickedForIndex = this.remainingParameters.first();
        this.remainingParameters.remove(parameterPickedForIndex);
        FilterParamIndexBase index = IndexFactory.createIndex(this.eventType, parameterPickedForIndex.getPropertyName(), parameterPickedForIndex.getFilterOperator());
        currentNode.getIndizes().add(index);
        treePathInfo.add(index, parameterPickedForIndex.getFilterForValue());
        this.addToIndex(index, parameterPickedForIndex.getFilterForValue(), treePathInfo);
        currentNode.getNodeRWLock().writeLock().unlock();
    }

    private boolean removeFromNode(FilterHandleSetNode currentNode, IndexTreePath treePathInfo) {
        boolean isRemoved;
        Pair<FilterParamIndexBase, Object> nextPair = treePathInfo.removeFirst();
        if (nextPair == null) {
            currentNode.getNodeRWLock().writeLock().lock();
            boolean isRemoved2 = currentNode.remove(this.filterCallback);
            boolean isEmpty = currentNode.isEmpty();
            if (!isRemoved2) {
                log.warn(".removeFromNode (" + this.currentThreadId + ") Could not find the filterCallback to be removed within the supplied node , node=" + currentNode + "  filterCallback=" + this.filterCallback);
            }
            currentNode.getNodeRWLock().writeLock().unlock();
            return isEmpty;
        }
        FilterParamIndexBase nextIndex = nextPair.getFirst();
        Object filteredForValue = nextPair.getSecond();
        currentNode.getNodeRWLock().writeLock().lock();
        boolean isEmpty = this.removeFromIndex(nextIndex, treePathInfo, filteredForValue);
        if (!isEmpty) {
            currentNode.getNodeRWLock().writeLock().unlock();
            return false;
        }
        if (nextIndex.size() == 0 && !(isRemoved = currentNode.remove(nextIndex))) {
            log.warn(".removeFromNode (" + this.currentThreadId + ") Could not find the index in index list for removal, index=" + nextIndex.toString() + "  filterCallback=" + this.filterCallback);
            currentNode.getNodeRWLock().writeLock().unlock();
            return false;
        }
        boolean isEmptyNode = currentNode.isEmpty();
        currentNode.getNodeRWLock().writeLock().unlock();
        return isEmptyNode;
    }

    private boolean removeFromIndex(FilterParamIndexBase index, IndexTreePath treePathInfo, Object filterForValue) {
        index.getReadWriteLock().writeLock().lock();
        EventEvaluator eventEvaluator = index.get(filterForValue);
        if (eventEvaluator == null) {
            log.warn(".removeFromIndex (" + this.currentThreadId + ") Could not find the filterCallback value in index, index=" + index.toString() + "  value=" + filterForValue.toString() + "  filterCallback=" + this.filterCallback);
            index.getReadWriteLock().writeLock().unlock();
            return false;
        }
        if (eventEvaluator instanceof FilterHandleSetNode) {
            FilterHandleSetNode node = (FilterHandleSetNode)eventEvaluator;
            boolean isEmpty = this.removeFromNode(node, treePathInfo);
            if (isEmpty) {
                index.remove(filterForValue);
            }
            int size = index.size();
            index.getReadWriteLock().writeLock().unlock();
            return size == 0;
        }
        FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
        Pair<FilterParamIndexBase, Object> nextPair = treePathInfo.removeFirst();
        if (nextPair == null) {
            log.fatal(".removeFromIndex Expected an inner index to this index, this=" + this.toString());
            index.getReadWriteLock().writeLock().unlock();
            assert (false);
            return false;
        }
        if (nextPair.getFirst() != nextIndex) {
            log.fatal(".removeFromIndex Expected an index for filterCallback that differs from the found index, this=" + this.toString() + "  expected=" + nextPair.getFirst());
            index.getReadWriteLock().writeLock().unlock();
            assert (false);
            return false;
        }
        Object nextExpressionValue = nextPair.getSecond();
        boolean isEmpty = this.removeFromIndex(nextPair.getFirst(), treePathInfo, nextExpressionValue);
        if (isEmpty) {
            index.remove(filterForValue);
        }
        int size = index.size();
        index.getReadWriteLock().writeLock().unlock();
        return size == 0;
    }

    private void addToIndex(FilterParamIndexBase index, Object filterForValue, IndexTreePath treePathInfo) {
        boolean added;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".addToIndex (" + this.currentThreadId + ") Adding to index " + index.toString() + "  expressionValue=" + filterForValue);
        }
        index.getReadWriteLock().readLock().lock();
        EventEvaluator eventEvaluator = index.get(filterForValue);
        if (eventEvaluator != null && (added = this.addToEvaluator(eventEvaluator, treePathInfo))) {
            index.getReadWriteLock().readLock().unlock();
            return;
        }
        index.getReadWriteLock().readLock().unlock();
        index.getReadWriteLock().writeLock().lock();
        eventEvaluator = index.get(filterForValue);
        if (eventEvaluator != null) {
            added = this.addToEvaluator(eventEvaluator, treePathInfo);
            if (added) {
                index.getReadWriteLock().writeLock().unlock();
                return;
            }
            FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
            FilterHandleSetNode newNode = new FilterHandleSetNode();
            newNode.add(nextIndex);
            index.put(filterForValue, newNode);
            this.addToNode(newNode, treePathInfo);
            index.getReadWriteLock().writeLock().unlock();
            return;
        }
        if (this.remainingParameters.isEmpty()) {
            FilterHandleSetNode node = new FilterHandleSetNode();
            this.addToNode(node, treePathInfo);
            index.put(filterForValue, node);
            index.getReadWriteLock().writeLock().unlock();
            return;
        }
        FilterValueSetParam parameterPickedForIndex = this.remainingParameters.first();
        this.remainingParameters.remove(parameterPickedForIndex);
        FilterParamIndexBase nextIndex = IndexFactory.createIndex(this.eventType, parameterPickedForIndex.getPropertyName(), parameterPickedForIndex.getFilterOperator());
        index.put(filterForValue, nextIndex);
        treePathInfo.add(nextIndex, parameterPickedForIndex.getFilterForValue());
        this.addToIndex(nextIndex, parameterPickedForIndex.getFilterForValue(), treePathInfo);
        index.getReadWriteLock().writeLock().unlock();
    }

    private boolean addToEvaluator(EventEvaluator eventEvaluator, IndexTreePath treePathInfo) {
        if (eventEvaluator instanceof FilterHandleSetNode) {
            FilterHandleSetNode node = (FilterHandleSetNode)eventEvaluator;
            this.addToNode(node, treePathInfo);
            return true;
        }
        FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
        FilterValueSetParam parameter = IndexHelper.findParameter(this.remainingParameters, nextIndex);
        if (parameter != null) {
            this.remainingParameters.remove(parameter);
            treePathInfo.add(nextIndex, parameter.getFilterForValue());
            this.addToIndex(nextIndex, parameter.getFilterForValue(), treePathInfo);
            return true;
        }
        return false;
    }

    protected static SortedSet<FilterValueSetParam> copySortParameters(List<FilterValueSetParam> parameters) {
        TreeSet<FilterValueSetParam> copy = new TreeSet<FilterValueSetParam>(new FilterValueSetParamComparator());
        for (FilterValueSetParam parameter : parameters) {
            copy.add(parameter);
        }
        if (copy.size() != parameters.size()) {
            throw new IllegalArgumentException("Filter parameters not unique by property name and filter operator");
        }
        return copy;
    }

    private String printRemainingParameters() {
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (FilterValueSetParam parameter : this.remainingParameters) {
            buffer.append("  param(").append(count).append(')');
            buffer.append(" property=").append(parameter.getPropertyName());
            buffer.append(" operator=").append((Object)parameter.getFilterOperator());
            buffer.append(" value=").append(parameter.getFilterForValue());
            ++count;
        }
        return buffer.toString();
    }
}

