/*
 * Decompiled with CFR 0.152.
 */
package net.esper.indicator.jmx;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import net.esper.event.EventBean;
import net.esper.indicator.jmx.JMXLastElementObserver;
import net.esper.indicator.pretty.CubeCellStringRenderer;
import net.esper.indicator.pretty.CubeTabularDataRenderer;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.ViewFieldEnum;
import net.esper.view.stat.olap.Cube;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JMXLastCubeElementDynamicMBean
implements JMXLastElementObserver {
    private OpenMBeanInfoSupport mBeanInfo;
    private Map<String, Double> cells = new HashMap<String, Double>();
    private Map<String, TabularData> tables = new HashMap<String, TabularData>();
    private static final Log log = LogFactory.getLog(JMXLastCubeElementDynamicMBean.class);

    public JMXLastCubeElementDynamicMBean() {
        this.setupMBeanInfo();
    }

    public final void setLastValue(EventBean element) {
        Cube cube = (Cube)element.get(ViewFieldEnum.MULTIDIM_OLAP__CUBE.getName());
        this.setCube(cube);
    }

    protected final void setCube(Cube cube) {
        this.cells = CubeCellStringRenderer.renderCube(cube);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".setCube Cells...");
            for (String attribute : this.cells.keySet()) {
                log.debug(".setCube Cell " + attribute + '=' + this.cells.get(attribute));
            }
        }
        this.tables = CubeTabularDataRenderer.renderCube(cube);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".setCube Tables...");
            for (String attribute : this.tables.keySet()) {
                log.debug(".setCube Table " + attribute + '=' + this.tables.get(attribute));
            }
        }
        this.setupMBeanInfo();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".setCube mBeanInfo.getAttributes().length=" + this.mBeanInfo.getAttributes().length);
        }
    }

    public final Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.cells.containsKey(attribute)) {
            return this.cells.get(attribute);
        }
        if (this.tables.containsKey(attribute)) {
            return this.tables.get(attribute);
        }
        throw new AttributeNotFoundException("Attribute named " + attribute + " was not found");
    }

    public final void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("Not supported");
    }

    public final AttributeList getAttributes(String[] attributes) {
        return null;
    }

    public final AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public final Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    public final MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    private void setupMBeanInfo() {
        OpenMBeanAttributeInfoSupport info;
        int newAttributeCount = this.cells.size() + this.tables.size();
        if (this.mBeanInfo != null && newAttributeCount == this.mBeanInfo.getAttributes().length) {
            return;
        }
        LinkedList<OpenMBeanAttributeInfoSupport> infoList = new LinkedList<OpenMBeanAttributeInfoSupport>();
        int index = 0;
        for (Map.Entry<String, Double> entry : this.cells.entrySet()) {
            info = new OpenMBeanAttributeInfoSupport(entry.getKey(), "cell #" + index, SimpleType.DOUBLE, true, false, false);
            infoList.add(info);
            ++index;
        }
        index = 0;
        for (Map.Entry<String, Object> entry : this.tables.entrySet()) {
            info = new OpenMBeanAttributeInfoSupport(entry.getKey(), "table #" + index, ((TabularData)entry.getValue()).getTabularType(), true, false, false);
            infoList.add(info);
            ++index;
        }
        this.mBeanInfo = new OpenMBeanInfoSupport(this.getClass().getName(), "Exposes cube as flattened-out cells and tables (typed JMX Open Bean TabularData)", infoList.toArray(new OpenMBeanAttributeInfoSupport[0]), null, null, null);
    }
}

