/*
 * Decompiled with CFR 0.152.
 */
package net.esper.indicator.jmx;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.indicator.jmx.JMXLastElementObserver;

public final class JMXLastElementDynamicMBean
implements JMXLastElementObserver {
    private final MBeanInfo mBeanInfo;
    private EventBean lastValue;

    public JMXLastElementDynamicMBean(EventType eventType) {
        this.mBeanInfo = JMXLastElementDynamicMBean.determineMBeanInfo(eventType);
    }

    public final MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    public final void setLastValue(EventBean lastValue) {
        this.lastValue = lastValue;
    }

    public final Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.lastValue == null) {
            return null;
        }
        return this.lastValue.get(attribute);
    }

    public final void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("Attribute " + attribute + " is not writable");
    }

    public final AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String key : attributes) {
            list.add(new Attribute(key, this.lastValue.get(key)));
        }
        return list;
    }

    public final AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public final Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    private static MBeanInfo determineMBeanInfo(EventType eventType) {
        String[] keys = eventType.getPropertyNames();
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[keys.length];
        for (int i = 0; i < infos.length; ++i) {
            String type = eventType.getPropertyType(keys[i]).getName();
            infos[i] = new MBeanAttributeInfo(keys[i], type, "", true, false, false);
        }
        return new MBeanInfo(JMXLastElementDynamicMBean.class.getName(), "", infos, null, null, null);
    }
}

