/*
 * Decompiled with CFR 0.152.
 */
package net.esper.indicator.jmx;

import java.lang.management.ManagementFactory;
import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.esper.client.UpdateListener;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.indicator.jmx.JMXLastCubeElementDynamicMBean;
import net.esper.indicator.jmx.JMXLastElementDynamicMBean;
import net.esper.indicator.jmx.JMXLastElementObserver;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.ViewFieldEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JMXLastEventIndicator
implements UpdateListener {
    private static int indexProperty;
    private JMXLastElementObserver observerMbean;
    private static final Log log;

    public JMXLastEventIndicator(EventType eventType, String domainName, String keyProperties) {
        this.observerMbean = eventType.isProperty(ViewFieldEnum.MULTIDIM_OLAP__CUBE.getName()) ? new JMXLastCubeElementDynamicMBean() : new JMXLastElementDynamicMBean(eventType);
        String objectName = domainName;
        objectName = keyProperties.length() != 0 ? objectName + ':' + keyProperties + ",indexProperty=" + indexProperty : objectName + ":indexProperty=" + ++indexProperty;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".setParent Registering mbean with name " + objectName);
        }
        JMXLastEventIndicator.registerMBean(objectName, this.observerMbean);
    }

    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null && newData.length > 0) {
            this.observerMbean.setLastValue(newData[newData.length - 1]);
        }
    }

    private static void registerMBean(String objectName, DynamicMBean dynamicMBean) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(objectName);
            mbs.registerMBean(dynamicMBean, name);
        }
        catch (Exception ex) {
            log.fatal(".registerMBean Unexpected exception registering MBean with object name " + objectName, ex);
        }
    }

    static {
        log = LogFactory.getLog(JMXLastEventIndicator.class);
    }
}

