/*
 * Decompiled with CFR 0.152.
 */
package net.esper.indicator.pretty;

import java.util.LinkedHashMap;
import java.util.Map;
import net.esper.indicator.pretty.DimensionMemberRenderHelper;
import net.esper.view.stat.olap.Cell;
import net.esper.view.stat.olap.Cube;
import net.esper.view.stat.olap.DimensionMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CubeCellStringRenderer {
    private static final String MEMBER_DELIMITER = "__";

    public static Map<String, Double> renderCube(Cube cube) {
        LinkedHashMap<String, Double> renderedCube = new LinkedHashMap<String, Double>();
        Cell[] measures = cube.getMeasures();
        for (int ordinal = 0; ordinal < measures.length; ++ordinal) {
            DimensionMember[] members = cube.getMembers(ordinal);
            String ordinalString = String.format("%1$4s", ordinal);
            String renderedCell = "Cell " + ordinalString + " : ";
            String renderedMember = CubeCellStringRenderer.renderMembers(members);
            String key = renderedCell + renderedMember;
            renderedCube.put(key, measures[ordinal].getValue());
        }
        return renderedCube;
    }

    private static String renderMembers(DimensionMember[] members) {
        StringBuilder buffer = new StringBuilder();
        String memberDelimiter = "";
        for (int i = 0; i < members.length; ++i) {
            String renderedValues = DimensionMemberRenderHelper.renderMember(members[i]);
            buffer.append(memberDelimiter).append(renderedValues);
            memberDelimiter = MEMBER_DELIMITER;
        }
        return buffer.toString();
    }
}

