/*
 * Decompiled with CFR 0.152.
 */
package net.esper.indicator.pretty;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import net.esper.client.EPException;
import net.esper.indicator.pretty.DimensionMemberRenderHelper;
import net.esper.view.stat.olap.Cube;
import net.esper.view.stat.olap.Dimension;
import net.esper.view.stat.olap.DimensionMember;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CubeTabularDataRenderer {
    private static final String TABLE_NAME = "Table";
    private static final String ROW_INDEX_COLUMN_NAME = "(0) row";
    private static final String KEY_COLUMN_NAME = "key";
    private static final String CELL_ROW_PRETTY_DELIMITER = "--";
    private static final Log log = LogFactory.getLog(CubeTabularDataRenderer.class);

    public static Map<String, TabularData> renderCube(Cube cube) {
        LinkedHashMap<String, TabularData> renderedCube = new LinkedHashMap<String, TabularData>();
        Dimension[] dimension = cube.getDimensions();
        if (dimension.length > 4) {
            throw new UnsupportedOperationException("Cannot renderCube cubes of more than 4 dimensions");
        }
        if (dimension.length < 4) {
            TabularData tableData = CubeTabularDataRenderer.renderTable(cube, 0);
            renderedCube.put(TABLE_NAME, tableData);
        } else {
            int sizeLastDimension = dimension[3].getMembers().length;
            int ordinalOffset = cube.getMeasures().length / sizeLastDimension;
            for (int i = 0; i < sizeLastDimension; ++i) {
                TabularData tableData = CubeTabularDataRenderer.renderTable(cube, ordinalOffset * i);
                String renderedMember = DimensionMemberRenderHelper.renderMember(dimension[3].getMembers()[i]);
                String renderedTable = "Table " + i + " : " + renderedMember;
                renderedCube.put(renderedTable, tableData);
            }
        }
        return renderedCube;
    }

    private static TabularData renderTable(Cube cube, int ordinalOffset) {
        String[] columnNames = CubeTabularDataRenderer.createColumnNames(cube);
        OpenType[] columnTypes = CubeTabularDataRenderer.createColumnTypes(cube);
        CompositeType rowCompositeType = null;
        try {
            rowCompositeType = new CompositeType("rows", "rows", columnNames, columnNames, columnTypes);
        }
        catch (OpenDataException ex) {
            log.fatal("Error creating row CompositeType", ex);
            throw new EPException(ex);
        }
        TabularType tabularType = null;
        try {
            tabularType = new TabularType("cubeType", "cube tabular rendering", rowCompositeType, new String[]{ROW_INDEX_COLUMN_NAME});
        }
        catch (OpenDataException ex) {
            log.fatal("Error creating row TabularType", ex);
            throw new EPException(ex);
        }
        TabularDataSupport tabularData = new TabularDataSupport(tabularType);
        List<Map<String, Object>> rows = null;
        rows = cube.getDimensions().length == 2 ? CubeTabularDataRenderer.makeRows_1Dimensional(cube, columnNames) : CubeTabularDataRenderer.makeRows_2Dimensional(cube, columnNames, ordinalOffset);
        for (Map<String, Object> itemMap : rows) {
            CompositeDataSupport row = null;
            try {
                row = new CompositeDataSupport(rowCompositeType, itemMap);
            }
            catch (OpenDataException ex) {
                log.fatal("Error adding row", ex);
                throw new EPException(ex);
            }
            tabularData.put(row);
        }
        return tabularData;
    }

    private static List<Map<String, Object>> makeRows_1Dimensional(Cube cube, String[] columnHeaders) {
        Dimension rowDimension = cube.getDimensions()[0];
        Dimension columnDimension = cube.getDimensions()[1];
        LinkedList<Map<String, Object>> rows = new LinkedList<Map<String, Object>>();
        for (int rowIndex = 0; rowIndex < rowDimension.getMembers().length; ++rowIndex) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            rowData.put(columnHeaders[0], rowIndex);
            String rendered = DimensionMemberRenderHelper.renderMember(rowDimension.getMembers()[rowIndex]);
            rowData.put(columnHeaders[1], rendered);
            for (int columnIndex = 0; columnIndex < columnDimension.getMembers().length; ++columnIndex) {
                String columnHeader = columnHeaders[columnIndex + 2];
                int ordinal = columnIndex + rowIndex * columnDimension.getMembers().length;
                double value = cube.getMeasures()[ordinal].getValue();
                rowData.put(columnHeader, value);
            }
            rows.add(rowData);
        }
        return rows;
    }

    private static List<Map<String, Object>> makeRows_2Dimensional(Cube cube, String[] columnHeaders, int ordinalOffset) {
        Dimension cellDimension = cube.getDimensions()[0];
        Dimension columnDimension = cube.getDimensions()[1];
        Dimension rowDimension = cube.getDimensions()[2];
        int cellDimSize = cellDimension.getMembers().length;
        int columnDimSize = columnDimension.getMembers().length;
        LinkedList<Map<String, Object>> rows = new LinkedList<Map<String, Object>>();
        int index = 0;
        for (int rowIndex = 0; rowIndex < rowDimension.getMembers().length; ++rowIndex) {
            for (int cellIndex = 0; cellIndex < cellDimension.getMembers().length; ++cellIndex) {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                rowData.put(columnHeaders[0], index);
                String renderedRow = DimensionMemberRenderHelper.renderMember(rowDimension.getMembers()[rowIndex]);
                String renderedCell = DimensionMemberRenderHelper.renderMember(cellDimension.getMembers()[cellIndex]);
                String renderedRowKey = renderedRow + CELL_ROW_PRETTY_DELIMITER + renderedCell;
                rowData.put(columnHeaders[1], renderedRowKey);
                for (int columnIndex = 0; columnIndex < columnDimension.getMembers().length; ++columnIndex) {
                    String columnHeader = columnHeaders[columnIndex + 2];
                    int ordinal = ordinalOffset + cellIndex + columnIndex * cellDimSize + rowIndex * cellDimSize * columnDimSize;
                    double value = cube.getMeasures()[ordinal].getValue();
                    rowData.put(columnHeader, value);
                }
                rows.add(rowData);
                ++index;
            }
        }
        return rows;
    }

    private static String[] createColumnNames(Cube cube) {
        Dimension columnDimension = cube.getDimensions()[1];
        LinkedList<String> columnNameList = new LinkedList<String>();
        columnNameList.add(ROW_INDEX_COLUMN_NAME);
        columnNameList.add(CubeTabularDataRenderer.renderColumnId(1) + ' ' + KEY_COLUMN_NAME);
        for (int memberIndex = 0; memberIndex < columnDimension.getMembers().length; ++memberIndex) {
            DimensionMember dimensionMember = columnDimension.getMembers()[memberIndex];
            int columnIndex = memberIndex + 2;
            String rendered = CubeTabularDataRenderer.renderColumnId(columnIndex) + ' ' + DimensionMemberRenderHelper.renderMember(dimensionMember);
            columnNameList.add(rendered);
        }
        return columnNameList.toArray(new String[0]);
    }

    private static OpenType[] createColumnTypes(Cube cube) {
        Dimension columnDimension = cube.getDimensions()[1];
        LinkedList<SimpleType<Object>> columnTypeList = new LinkedList<SimpleType<Object>>();
        columnTypeList.add(SimpleType.INTEGER);
        columnTypeList.add(SimpleType.STRING);
        for (int i = 0; i < columnDimension.getMembers().length; ++i) {
            columnTypeList.add(SimpleType.DOUBLE);
        }
        return columnTypeList.toArray(new OpenType[0]);
    }

    private static String renderColumnId(int columnId) {
        return "(" + columnId + ')';
    }
}

