/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern;

import java.util.LinkedList;
import java.util.List;
import net.esper.pattern.EvalEveryNode;
import net.esper.pattern.EvalEveryStateSpawnEvaluator;
import net.esper.pattern.EvalFilterStateNode;
import net.esper.pattern.EvalNode;
import net.esper.pattern.EvalStateNode;
import net.esper.pattern.EvalStateNodeVisitor;
import net.esper.pattern.Evaluator;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalEveryStateNode
extends EvalStateNode
implements Evaluator {
    private final List<EvalStateNode> spawnedNodes;
    private final MatchedEventMap beginState;
    private final PatternContext context;
    private static final Log log = LogFactory.getLog(EvalEveryStateNode.class);

    public EvalEveryStateNode(Evaluator parentNode, EvalEveryNode everyNode, MatchedEventMap beginState, PatternContext context) {
        super(everyNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.spawnedNodes = new LinkedList<EvalStateNode>();
        this.beginState = beginState.shallowCopy();
        this.context = context;
        EvalStateNode child = this.getFactoryNode().getChildNodes().get(0).newState(this, beginState, context, null);
        this.spawnedNodes.add(child);
    }

    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting single child");
        }
        if (this.spawnedNodes.size() != 1) {
            throw new IllegalStateException("EVERY state node is expected to have single child state node");
        }
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator();
        EvalStateNode child = this.spawnedNodes.get(0);
        child.setParentEvaluator(spawnEvaluator);
        child.start();
        if (spawnEvaluator.isEvaluatedTrue()) {
            child.quit();
        } else {
            child.setParentEvaluator(this);
        }
    }

    public final void evaluateFalse(EvalStateNode fromNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse");
        }
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        EvalNode child = this.getFactoryNode().getChildNodes().get(0);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator();
        EvalStateNode spawned = child.newState(spawnEvaluator, this.beginState, this.context, null);
        spawned.start();
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.add(spawned);
            spawned.setParentEvaluator(this);
        }
    }

    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue fromNode=" + fromNode + "  isQuitted=" + isQuitted);
        }
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!(fromNode instanceof EvalFilterStateNode)) {
            EvalNode child = this.getFactoryNode().getChildNodes().get(0);
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator();
            EvalStateNode spawned = child.newState(spawnEvaluator, this.beginState, this.context, null);
            spawned.start();
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                this.spawnedNodes.add(spawned);
                spawned.setParentEvaluator(this);
            }
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, false);
    }

    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Quitting EVERY-node all children");
        }
        for (EvalStateNode child : this.spawnedNodes) {
            child.quit();
        }
    }

    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode spawnedNode : this.spawnedNodes) {
            spawnedNode.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

