/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern;

import net.esper.eql.spec.FilterSpecRaw;
import net.esper.filter.FilterSpecCompiled;
import net.esper.pattern.EvalNode;
import net.esper.pattern.EvalStateNode;
import net.esper.pattern.Evaluator;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalFilterNode
extends EvalNode {
    private final FilterSpecRaw rawFilterSpec;
    private final String eventAsName;
    private FilterSpecCompiled filterSpec;
    private static final Log log = LogFactory.getLog(EvalFilterNode.class);

    public final EvalStateNode newState(Evaluator parentNode, MatchedEventMap beginState, PatternContext context, Object stateNodeId) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".newState");
        }
        if (!this.getChildNodes().isEmpty()) {
            throw new IllegalStateException("Expected number of child nodes incorrect, expected no child nodes, found " + this.getChildNodes().size());
        }
        return context.getPatternStateFactory().makeFilterStateNode(parentNode, this, beginState, stateNodeId);
    }

    public EvalFilterNode(FilterSpecRaw filterSpecification, String eventAsName) {
        this.rawFilterSpec = filterSpecification;
        this.eventAsName = eventAsName;
    }

    public FilterSpecRaw getRawFilterSpec() {
        return this.rawFilterSpec;
    }

    public final FilterSpecCompiled getFilterSpec() {
        return this.filterSpec;
    }

    public void setFilterSpec(FilterSpecCompiled filterSpec) {
        this.filterSpec = filterSpec;
    }

    public final String getEventAsName() {
        return this.eventAsName;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterNode rawFilterSpec=" + this.rawFilterSpec);
        buffer.append(" filterSpec=" + this.filterSpec);
        buffer.append(" eventAsName=" + this.eventAsName);
        return buffer.toString();
    }
}

