/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern;

import net.esper.core.EPStatementHandleCallback;
import net.esper.event.EventBean;
import net.esper.filter.FilterHandleCallback;
import net.esper.filter.FilterValueSet;
import net.esper.pattern.EvalEveryStateNode;
import net.esper.pattern.EvalFilterNode;
import net.esper.pattern.EvalStateNode;
import net.esper.pattern.EvalStateNodeVisitor;
import net.esper.pattern.Evaluator;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalFilterStateNode
extends EvalStateNode
implements FilterHandleCallback {
    private final EvalFilterNode evalFilterNode;
    private final MatchedEventMap beginState;
    private final PatternContext context;
    private boolean isStarted;
    private EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(EvalFilterStateNode.class);

    public EvalFilterStateNode(Evaluator parentNode, EvalFilterNode evalFilterNode, MatchedEventMap beginState, PatternContext context) {
        super(evalFilterNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.evalFilterNode = evalFilterNode;
        this.beginState = beginState;
        this.context = context;
    }

    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting filter expression");
        }
        if (this.isStarted) {
            throw new IllegalStateException("Filter state node already active");
        }
        this.isStarted = true;
        this.startFiltering();
    }

    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Stop filter expression");
        }
        this.isStarted = false;
        this.stopFiltering();
    }

    private void evaluateTrue(MatchedEventMap event, boolean isQuitted) {
        this.getParentEvaluator().evaluateTrue(event, this, isQuitted);
    }

    public final void matchFound(EventBean event) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".matchFound Filter node received match");
        }
        if (!this.isStarted) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug(".matchFound Match ignored, filter was stopped");
            }
            return;
        }
        MatchedEventMap passUp = this.beginState.shallowCopy();
        if (this.evalFilterNode.getEventAsName() != null) {
            passUp.add(this.evalFilterNode.getEventAsName(), event);
        }
        boolean isQuitted = false;
        if (!(this.getParentEvaluator() instanceof EvalEveryStateNode)) {
            this.stopFiltering();
            isQuitted = true;
        }
        this.evaluateTrue(passUp, isQuitted);
    }

    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        return data;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterStateNode");
        buffer.append(" tag=");
        buffer.append(this.evalFilterNode.getFilterSpec());
        buffer.append(" spec=");
        buffer.append(this.evalFilterNode.getFilterSpec());
        return buffer.toString();
    }

    private void startFiltering() {
        this.handle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), this);
        FilterValueSet filterValues = this.evalFilterNode.getFilterSpec().getValueSet(this.beginState);
        this.context.getFilterService().add(filterValues, this.handle);
    }

    private void stopFiltering() {
        this.context.getFilterService().remove(this.handle);
        this.handle = null;
        this.isStarted = false;
    }
}

