/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern;

import net.esper.pattern.EvalGuardNode;
import net.esper.pattern.EvalStateNode;
import net.esper.pattern.EvalStateNodeVisitor;
import net.esper.pattern.Evaluator;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.pattern.guard.Guard;
import net.esper.pattern.guard.Quitable;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalGuardStateNode
extends EvalStateNode
implements Evaluator,
Quitable {
    private EvalStateNode activeChildNode;
    private final Guard guard;
    private static final Log log = LogFactory.getLog(EvalGuardStateNode.class);

    public EvalGuardStateNode(Evaluator parentNode, EvalGuardNode evalGuardNode, MatchedEventMap beginState, PatternContext context, Object stateObjectId) {
        super(evalGuardNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.guard = evalGuardNode.getGuardFactory().makeGuard(context, this, stateObjectId, null);
        this.activeChildNode = evalGuardNode.getChildNodes().get(0).newState(this, beginState, context, null);
    }

    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting within timer and single child node");
        }
        if (this.activeChildNode == null) {
            throw new IllegalStateException("Invalid state, child state node is inactive");
        }
        this.activeChildNode.start();
        this.guard.startGuard();
    }

    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        boolean guardPass;
        boolean haveQuitted;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue fromNode=" + fromNode.hashCode());
        }
        boolean bl = haveQuitted = this.activeChildNode == null;
        if (isQuitted) {
            this.activeChildNode = null;
            this.guard.stopGuard();
        }
        if (!haveQuitted && (guardPass = this.guard.inspect(matchEvent))) {
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted);
        }
    }

    public final void evaluateFalse(EvalStateNode fromNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse Removing fromNode=" + fromNode.hashCode());
        }
    }

    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Stopping all children");
        }
        if (this.activeChildNode != null) {
            this.activeChildNode.quit();
            this.guard.stopGuard();
        }
        this.activeChildNode = null;
    }

    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        if (this.activeChildNode != null) {
            this.activeChildNode.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvaluationWitinStateNode activeChildNode=" + this.activeChildNode + " guard=" + this.guard;
    }

    public void guardQuit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Guard has quit, stopping child node, activeChildNode=" + this.activeChildNode);
        }
        if (this.activeChildNode != null) {
            this.activeChildNode.quit();
        }
        this.activeChildNode = null;
    }
}

