/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern;

import java.util.ArrayList;
import java.util.List;
import net.esper.pattern.EvalFilterNode;
import net.esper.pattern.EvalGuardNode;
import net.esper.pattern.EvalNodeAnalysisResult;
import net.esper.pattern.EvalNodeNumber;
import net.esper.pattern.EvalObserverNode;
import net.esper.pattern.EvalStateNode;
import net.esper.pattern.Evaluator;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.util.MetaDefItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EvalNode
implements MetaDefItem {
    private final List<EvalNode> childNodes = new ArrayList<EvalNode>();
    private EvalNodeNumber nodeNumber;
    private static final Log log = LogFactory.getLog(EvalNode.class);

    public abstract EvalStateNode newState(Evaluator var1, MatchedEventMap var2, PatternContext var3, Object var4);

    EvalNode() {
    }

    public EvalNodeNumber getNodeNumber() {
        return this.nodeNumber;
    }

    public void setNodeNumber(EvalNodeNumber nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    public final void addChildNode(EvalNode childNode) {
        this.childNodes.add(childNode);
    }

    public final List<EvalNode> getChildNodes() {
        return this.childNodes;
    }

    public final void dumpDebug(String prefix) {
        if (log.isDebugEnabled()) {
            log.debug(".dumpDebug " + prefix + this.toString());
        }
        for (EvalNode node : this.childNodes) {
            node.dumpDebug(prefix + "  ");
        }
    }

    public static EvalNodeAnalysisResult recursiveAnalyzeChildNodes(EvalNode currentNode) {
        EvalNodeAnalysisResult evalNodeAnalysisResult = new EvalNodeAnalysisResult();
        EvalNode.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, currentNode);
        return evalNodeAnalysisResult;
    }

    private static void recursiveAnalyzeChildNodes(EvalNodeAnalysisResult evalNodeAnalysisResult, EvalNode currentNode) {
        if (currentNode instanceof EvalFilterNode) {
            evalNodeAnalysisResult.add((EvalFilterNode)currentNode);
        }
        if (currentNode instanceof EvalGuardNode) {
            evalNodeAnalysisResult.add((EvalGuardNode)currentNode);
        }
        if (currentNode instanceof EvalObserverNode) {
            evalNodeAnalysisResult.add((EvalObserverNode)currentNode);
        }
        for (EvalNode node : currentNode.getChildNodes()) {
            EvalNode.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, node);
        }
    }
}

