/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern;

import java.util.LinkedList;
import java.util.List;
import net.esper.pattern.EvalNode;
import net.esper.pattern.EvalOrNode;
import net.esper.pattern.EvalStateNode;
import net.esper.pattern.EvalStateNodeVisitor;
import net.esper.pattern.Evaluator;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalOrStateNode
extends EvalStateNode
implements Evaluator {
    private final List<EvalStateNode> childNodes;
    private static final Log log = LogFactory.getLog(EvalOrStateNode.class);

    public EvalOrStateNode(Evaluator parentNode, EvalOrNode evalOrNode, MatchedEventMap beginState, PatternContext context) {
        super(evalOrNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.childNodes = new LinkedList<EvalStateNode>();
        for (EvalNode node : this.getFactoryNode().getChildNodes()) {
            EvalStateNode childState = node.newState(this, beginState, context, null);
            this.childNodes.add(childState);
        }
    }

    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting or-expression all children, size=" + this.getFactoryNode().getChildNodes().size());
        }
        if (this.childNodes.size() != this.getFactoryNode().getChildNodes().size()) {
            throw new IllegalStateException("OR state node does not have the required child state nodes");
        }
        for (EvalStateNode child : this.childNodes) {
            child.start();
        }
    }

    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue fromNode=" + fromNode.hashCode());
        }
        if (isQuitted) {
            this.childNodes.remove(fromNode);
            this.quit();
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted);
    }

    public final void evaluateFalse(EvalStateNode fromNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse fromNode=" + fromNode.hashCode());
        }
    }

    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Stopping all children");
        }
        for (EvalStateNode child : this.childNodes) {
            child.quit();
        }
        this.childNodes.clear();
    }

    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.childNodes) {
            node.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalOrStateNode nodes=" + this.childNodes.size();
    }
}

