/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern;

import net.esper.pattern.EvalNode;
import net.esper.pattern.EvalRootState;
import net.esper.pattern.EvalStateNode;
import net.esper.pattern.EvalStateNodePrinterVisitor;
import net.esper.pattern.EvalStateNodeVisitor;
import net.esper.pattern.Evaluator;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.pattern.PatternMatchCallback;
import net.esper.pattern.PatternStopCallback;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalRootStateNode
extends EvalStateNode
implements Evaluator,
PatternStopCallback,
EvalRootState {
    private EvalStateNode topStateNode;
    private PatternMatchCallback callback;
    private static final Log log = LogFactory.getLog(EvalRootStateNode.class);

    public EvalRootStateNode(EvalNode rootSingleChildNode, MatchedEventMap beginState, PatternContext context) {
        super(rootSingleChildNode, null, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.topStateNode = rootSingleChildNode.newState(this, beginState, context, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor Done, dumping full tree");
            EvalStateNodePrinterVisitor visitor = new EvalStateNodePrinterVisitor();
            this.accept(visitor, null);
        }
    }

    public final void setCallback(PatternMatchCallback callback) {
        this.callback = callback;
    }

    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting single child");
        }
        if (this.topStateNode == null) {
            throw new IllegalStateException("root state node is inactive");
        }
        this.topStateNode.start();
    }

    public final void stop() {
        this.quit();
    }

    public final void quit() {
        if (this.topStateNode != null) {
            this.topStateNode.quit();
        }
        this.topStateNode = null;
    }

    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue isQuitted=" + isQuitted);
        }
        if (isQuitted) {
            this.topStateNode = null;
        }
        this.callback.matchFound(matchEvent.getMatchingEvents());
    }

    public final void evaluateFalse(EvalStateNode fromNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse");
        }
    }

    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        if (this.topStateNode != null) {
            this.topStateNode.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalRootStateNode topStateNode=" + this.topStateNode;
    }
}

