/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern;

import java.util.HashMap;
import java.util.Map;
import net.esper.event.EventBean;
import net.esper.pattern.MatchedEventMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchedEventMapImpl
implements MatchedEventMap {
    private Map<String, EventBean> events = new HashMap<String, EventBean>();

    public MatchedEventMapImpl() {
    }

    public MatchedEventMapImpl(Map<String, EventBean> events) {
        this.events = events;
    }

    @Override
    public void add(String tag, EventBean event) {
        this.events.put(tag, event);
    }

    @Override
    public Map<String, EventBean> getMatchingEvents() {
        return this.events;
    }

    @Override
    public EventBean getMatchingEvent(String tag) {
        return this.events.get(tag);
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        MatchedEventMapImpl other = (MatchedEventMapImpl)otherObject;
        if (this.events.size() != other.events.size()) {
            return false;
        }
        for (Map.Entry<String, EventBean> entry : this.events.entrySet()) {
            String tag = entry.getKey();
            EventBean event = entry.getValue();
            if (other.getMatchingEvent(tag) == event) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, EventBean> entry : this.events.entrySet()) {
            buffer.append(" (");
            buffer.append(count++);
            buffer.append(") ");
            buffer.append("tag=");
            buffer.append(entry.getKey());
            buffer.append("  event=");
            buffer.append(entry.getValue());
        }
        return buffer.toString();
    }

    public int hashCode() {
        return ((Object)this.events).hashCode();
    }

    @Override
    public MatchedEventMapImpl shallowCopy() {
        HashMap<String, EventBean> copy = new HashMap<String, EventBean>();
        copy.putAll(this.events);
        return new MatchedEventMapImpl(copy);
    }

    @Override
    public void merge(MatchedEventMap other) {
        if (!(other instanceof MatchedEventMapImpl)) {
            throw new UnsupportedOperationException("Merge requires same types");
        }
        MatchedEventMapImpl otherImpl = (MatchedEventMapImpl)other;
        this.events.putAll(otherImpl.events);
    }
}

